/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.udfdebugging.modules.jprofiler;

import com.exasol.bucketfs.Bucket;
import com.exasol.bucketfs.BucketAccessException;
import com.exasol.errorreporting.ExaError;
import com.exasol.udfdebugging.Module;
import com.exasol.udfdebugging.modules.jprofiler.InArchiveProfilerAgentPathDetector;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;

class JProfilerModule
implements Module {
    public static final String AGENT_OPTION = "jProfilerAgent";
    private final String jvmOption;
    private final Path jprofilerArchive = this.getJProfilerArchive();

    JProfilerModule(Bucket bucket) {
        this.assertProfilerExists(this.jprofilerArchive);
        String inArchivePath = new InArchiveProfilerAgentPathDetector().findPathToAgent(this.jprofilerArchive);
        this.uploadProfiler(bucket);
        this.jvmOption = "-agentpath:/buckets/" + bucket.getBucketFsName() + "/" + bucket.getBucketName() + "/jprofiler/" + inArchivePath + "=port=11002";
    }

    private void uploadProfiler(Bucket bucket) {
        try {
            bucket.uploadFile(this.jprofilerArchive, "jprofiler.tar.gz");
        }
        catch (BucketAccessException | FileNotFoundException | TimeoutException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-UDJ-13").message("Failed to upload jprofiler tar", new Object[0]).toString(), exception);
        }
    }

    private void assertProfilerExists(Path jprofilerAgent) {
        if (!Files.exists(jprofilerAgent, new LinkOption[0])) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-UDJ-8").message("Could not find jprofiler archive or open on path {{agent path}}).", new Object[]{jprofilerAgent}).mitigation("Please download the JProfiler for Linux without JRE from the JProfiler website and specify the commandline option -DjProfilerAgent=<PATH TO jprofiler.tar.gz> or save it as ~/jprofiler.tar.gz.", new Object[0]).toString());
        }
    }

    private Path getJProfilerArchive() {
        String jProfilerAgentProperty = System.getProperty(AGENT_OPTION, "");
        if (jProfilerAgentProperty.isBlank()) {
            return Path.of(System.getProperty("user.home"), new String[0]).resolve("jprofiler.tar.gz");
        }
        return Path.of(jProfilerAgentProperty, new String[0]);
    }

    @Override
    public Stream<String> getJvmOptions() {
        return Stream.of(this.jvmOption);
    }
}

