/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.udfdebugging.modules.udflogs;

import com.exasol.errorreporting.ExaError;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;

public final class LogRecorder
implements AutoCloseable {
    private static final Path LOG_DIRECTORY = Path.of("target/udf-logs", new String[0]);
    private final Server server;

    public LogRecorder(Consumer<Path> logFileHandler) {
        try {
            if (!Files.exists(LOG_DIRECTORY, new LinkOption[0])) {
                Files.createDirectory(LOG_DIRECTORY, new FileAttribute[0]);
            }
            this.server = new Server(logFileHandler);
            new Thread(this.server).start();
        }
        catch (IOException exception) {
            throw new UncheckedIOException(ExaError.messageBuilder((String)"E-UDJ-18").message("Failed to start server for retrieving UDF logs.", new Object[]{exception}).toString(), exception);
        }
    }

    @Override
    public void close() throws Exception {
        this.server.close();
    }

    public int getPort() {
        return this.server.getPort();
    }

    private static class Logger
    implements Runnable {
        private final Socket socket;
        private final Consumer<Path> logFileHandler;

        private Logger(Socket socket, Consumer<Path> logFileHandler) {
            this.socket = socket;
            this.logFileHandler = logFileHandler;
        }

        @Override
        public void run() {
            try {
                Path logFile = Files.createTempFile(LOG_DIRECTORY, "udf-log-", ".txt", new FileAttribute[0]);
                this.logFileHandler.accept(logFile);
                Files.copy(this.socket.getInputStream(), logFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException exception) {
                throw new UncheckedIOException(ExaError.messageBuilder((String)"E-UDJ-17").message("Failed to read from log stream.", new Object[0]).toString(), exception);
            }
            finally {
                try {
                    if (!this.socket.isClosed()) {
                        this.socket.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class Server
    implements Runnable,
    Closeable {
        private final ServerSocket serverSocket;
        private final Consumer<Path> logFileHandler;
        private boolean running = true;

        public Server(Consumer<Path> logFileHandler) throws IOException {
            this.logFileHandler = logFileHandler;
            this.serverSocket = new ServerSocket(0);
        }

        int getPort() {
            return this.serverSocket.getLocalPort();
        }

        @Override
        public void run() {
            try {
                while (this.running) {
                    Socket client = this.serverSocket.accept();
                    new Thread(new Logger(client, this.logFileHandler)).start();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void close() throws IOException {
            this.serverSocket.close();
            this.running = false;
        }
    }
}

