/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.udfdebugging.modules.udflogs;

import com.exasol.errorreporting.ExaError;
import com.exasol.exasoltestsetup.ServiceAddress;
import com.exasol.udfdebugging.LocalServiceExposer;
import com.exasol.udfdebugging.Module;
import com.exasol.udfdebugging.modules.udflogs.LogRecorder;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class UdfLogsModule
implements Module {
    private static final Logger LOGGER = Logger.getLogger(UdfLogsModule.class.getName());
    private final LogRecorder logRecorder;
    private final List<Path> capturedLogFiles = new ArrayList<Path>();

    public UdfLogsModule(LocalServiceExposer localServiceExposer, Connection exasolConnection) {
        Consumer<Path> logFileHandler = file -> {
            this.capturedLogFiles.add((Path)file);
            LOGGER.log(Level.INFO, "Created log file for UDF output: {0}", file);
        };
        this.logRecorder = new LogRecorder(logFileHandler);
        ServiceAddress inDbAddress = localServiceExposer.exposeLocalServiceToDatabase(this.logRecorder.getPort());
        this.redirectLogging(exasolConnection, inDbAddress);
    }

    @Override
    public Stream<String> getJvmOptions() {
        return Stream.empty();
    }

    public List<Path> getCapturedLogFiles() {
        return this.capturedLogFiles;
    }

    private void redirectLogging(Connection exasolConnection, ServiceAddress logServerAddress) {
        try (Statement statement = exasolConnection.createStatement();){
            String logServerAddressString = logServerAddress.toString();
            if (logServerAddressString.contains("'")) {
                throw new IllegalArgumentException(ExaError.messageBuilder((String)"F-UDJ-19").message("Invalid address {{address}}. The address must not contain a quotes.", new Object[]{logServerAddressString}).toString());
            }
            statement.executeUpdate("ALTER SESSION SET SCRIPT_OUTPUT_ADDRESS = '" + logServerAddressString + "';");
        }
        catch (SQLException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-UDJ-16").message("Failed to set script output address.", new Object[0]).toString(), exception);
        }
    }

    @Override
    public void close() {
        try {
            this.logRecorder.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

