/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.udfdebugging;

import com.exasol.bucketfs.Bucket;
import com.exasol.exasoltestsetup.ExasolTestSetup;
import com.exasol.udfdebugging.LocalServiceExposer;
import com.exasol.udfdebugging.Module;
import com.exasol.udfdebugging.ModuleFactory;
import com.exasol.udfdebugging.modules.coverage.CoverageModuleFactory;
import com.exasol.udfdebugging.modules.debugging.DebuggingModuleFactory;
import com.exasol.udfdebugging.modules.jprofiler.JProfilerModuleFactory;
import com.exasol.udfdebugging.modules.udflogs.UdfLogsModuleFactory;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdfTestSetup
implements AutoCloseable {
    private static final List<ModuleFactory> AVAILABLE_MODULES = List.of(new DebuggingModuleFactory(), new CoverageModuleFactory(), new JProfilerModuleFactory(), new UdfLogsModuleFactory());
    private static final Logger LOGGER = LoggerFactory.getLogger(UdfTestSetup.class);
    private final List<Module> enabledModules = AVAILABLE_MODULES.stream().filter(ModuleFactory::isEnabled).map(moduleFactory -> moduleFactory.buildModule(localServiceExposer, bucket, exasolConnection)).collect(Collectors.toList());

    public UdfTestSetup(String testHostIpAddress, Bucket bucket, Connection exasolConnection) {
        this((int port) -> new InetSocketAddress(testHostIpAddress, port), bucket, exasolConnection);
    }

    private UdfTestSetup(LocalServiceExposer localServiceExposer, Bucket bucket, Connection exasolConnection) {
        this.printInfoMessage();
    }

    public UdfTestSetup(ExasolTestSetup testSetup, Connection exasolConnection) {
        this((int port) -> {
            InetSocketAddress serviceAddress = testSetup.makeLocalTcpServiceAccessibleFromDatabase(port);
            return new InetSocketAddress(serviceAddress.getHostName(), serviceAddress.getPort());
        }, testSetup.getDefaultBucket(), exasolConnection);
    }

    public String[] getJvmOptions() {
        return (String[])this.enabledModules.stream().flatMap(Module::getJvmOptions).toArray(String[]::new);
    }

    private void printInfoMessage() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(this.getInfoMessage());
        }
    }

    private String getInfoMessage() {
        return AVAILABLE_MODULES.stream().map(module -> module.getModulePropertyName() + ": " + (module.isEnabled() ? "\u2713" : "\u2717")).collect(Collectors.joining("; ")) + "\n";
    }

    @Override
    public void close() {
        for (Module enabledModule : this.enabledModules) {
            try {
                enabledModule.close();
            }
            catch (Exception exception) {}
        }
    }
}

