/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.udfdebugging.modules.jprofiler;

import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

class InArchiveProfilerAgentPathDetector {
    private static final String AGENT_NAME = "linux-x64/libjprofilerti.so";

    InArchiveProfilerAgentPathDetector() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String findPathToAgent(Path jprofilerArchive) {
        try (TarArchiveInputStream tarInput = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(Files.newInputStream(jprofilerArchive, new OpenOption[0])));){
            ArchiveEntry nextEntry = tarInput.getNextEntry();
            while (nextEntry != null) {
                String entryPath = nextEntry.getName();
                if (entryPath.endsWith(AGENT_NAME)) {
                    String string = entryPath;
                    return string;
                }
                nextEntry = tarInput.getNextEntry();
            }
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-UDJ-15").message("Could not find linux-x64/libjprofilerti.so in the provided jprofiler archive ({{archive file}}).", new Object[]{jprofilerArchive}).mitigation("Make sure that you specified the correct jprofiler archive.", new Object[0]).mitigation("Future version of JProfiler could also have different agent file names. In that case, please open a ticket.", new Object[0]).toString());
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"F-UDJ-14").message("Failed to extract JProfiler tar.gz archive for extracting the version information.", new Object[0]).ticketMitigation().toString(), exception);
        }
    }
}

