/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.handler.call;

import com.exsoloscript.challonge.handler.call.ChallongeApiCall;
import com.exsoloscript.challonge.handler.call.RetrofitChallongeApiCallFactory;
import com.exsoloscript.challonge.handler.retrofit.RetrofitMatchHandler;
import com.exsoloscript.challonge.handler.retrofit.RetrofitServiceProvider;
import com.exsoloscript.challonge.model.Match;
import com.exsoloscript.challonge.model.enumeration.MatchState;
import com.exsoloscript.challonge.model.query.MatchQuery;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@Singleton
public class MatchHandler {
    private final RetrofitMatchHandler matchHandler;
    private final RetrofitChallongeApiCallFactory factory;

    @Inject
    MatchHandler(RetrofitServiceProvider provider, RetrofitChallongeApiCallFactory factory) {
        this.matchHandler = provider.createService(RetrofitMatchHandler.class);
        this.factory = factory;
    }

    public ChallongeApiCall<List<Match>> getMatches(String tournament, Integer participantId, MatchState state) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tournament), (String)"Tournament string is required", (Object[])new Object[0]);
        return this.factory.createApiCall(this.matchHandler.getMatches(tournament, participantId, state));
    }

    public ChallongeApiCall<List<Match>> getMatches(String tournament) {
        return this.getMatches(tournament, null, null);
    }

    public ChallongeApiCall<Match> getMatch(String tournament, int matchId, boolean includeAttachments) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tournament), (String)"Tournament string is required", (Object[])new Object[0]);
        return this.factory.createApiCall(this.matchHandler.getMatch(tournament, matchId, includeAttachments ? 1 : 0));
    }

    public ChallongeApiCall<Match> updateMatch(String tournament, int matchId, MatchQuery match) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tournament), (String)"Tournament string is required", (Object[])new Object[0]);
        return this.factory.createApiCall(this.matchHandler.updateMatch(tournament, matchId, match));
    }
}

