/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FacebookParam implements CharSequence
{
    SIGNATURE,
    ADDED("added"),
    API_KEY("api_key"),
    FRIENDS("friends"),
    LOCALE("locale"),
    TIME("time"),
    USER("user"),
    CANVAS_USER("canvas_user"),
    SESSION_KEY("session_key"),
    EXPIRES("expires"),
    PROFILE_UPDATE_TIME("profile_update_time"),
    EXT_PERMS("ext_perms"),
    IN_CANVAS("in_canvas"),
    IN_PROFILE_TAB("in_profile_tab"),
    PROFILE_USER("profile_user"),
    PROFILE_SESSION_KEY("profile_session_key"),
    PAGE_ID("page_id"),
    PAGE_ADDED("page_added"),
    REQUEST_METHOD("request_method"),
    IN_NEW_FACEBOOK("in_new_facebook"),
    IN_IFRAME("in_iframe"),
    SMS("sms"),
    MESSAGE("message"),
    SMS_SID("sms_sid"),
    SMS_NEW_USER("sms_new_user"),
    POSITION_FIX("position_fix"),
    UNINSTALL("uninstall");

    private static final Map<String, FacebookParam> _lookupTable;
    private String _paramName;
    private String _signatureName;

    public static FacebookParam get(String key) {
        return _lookupTable.get(key);
    }

    public static boolean isInNamespace(String key) {
        return null != key && key.startsWith("fb_sig");
    }

    public static boolean isSignature(String key) {
        return null != key && key.equals("fb_sig");
    }

    private FacebookParam() {
        this._paramName = "fb_sig";
    }

    private FacebookParam(String name) {
        this._signatureName = name;
        this._paramName = "fb_sig_" + name;
    }

    @Override
    public char charAt(int index) {
        return this._paramName.charAt(index);
    }

    @Override
    public int length() {
        return this._paramName.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this._paramName.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this._paramName;
    }

    public String getSignatureName() {
        return this._signatureName;
    }

    public static String stripSignaturePrefix(String paramName) {
        if (paramName != null && paramName.startsWith("fb_sig_")) {
            return paramName.substring(7);
        }
        return paramName;
    }

    static {
        _lookupTable = new HashMap<String, FacebookParam>();
        for (FacebookParam param : FacebookParam.values()) {
            _lookupTable.put(param.toString(), param);
        }
    }
}

