/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import com.facebook.api.ErrorCode;
import com.facebook.api.FacebookException;
import com.facebook.api.MarketListingCategory;
import com.facebook.api.MarketListingSubcategory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class MarketListing {
    protected static Log log = LogFactory.getLog(MarketListing.class);
    public static final String CONDITION_ANY = "ANY";
    public static final String CONDITION_NEW = "NEW";
    public static final String CONDITION_USED = "USED";
    protected static final String CATEGORY_ATTRIB = "category";
    protected static final String SUBCATEGORY_ATTRIB = "subcategory";
    protected static final String TITLE_ATTRIB = "title";
    protected static final String DESCRIPTION_ATTRIB = "description";
    protected JSONObject attribs;

    private MarketListing() {
    }

    public MarketListing(String title, String description, MarketListingCategory category, MarketListingSubcategory subcategory) {
        this.attribs = new JSONObject();
        this.setAttribute(TITLE_ATTRIB, title);
        this.setAttribute(DESCRIPTION_ATTRIB, description);
        this.setAttribute(CATEGORY_ATTRIB, category.getName());
        this.setAttribute(SUBCATEGORY_ATTRIB, subcategory.getName());
    }

    MarketListing(String json) {
        try {
            this.attribs = new JSONObject(json);
        }
        catch (Exception e) {
            this.attribs = new JSONObject();
        }
    }

    public void setAttribute(String name, String value) {
        try {
            this.attribs.put(name, (Object)value);
        }
        catch (Exception ex) {
            log.warn((Object)"Exception when setting listing attribute!", (Throwable)ex);
        }
    }

    public String getAttribute(String name) {
        String result = null;
        try {
            result = (String)this.attribs.get(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    String getAttribs() {
        return this.attribs.toString();
    }

    boolean verify() throws FacebookException {
        if (!this.checkString(TITLE_ATTRIB)) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The 'title' attribute may not be null or empty!");
        }
        if (!this.checkString(DESCRIPTION_ATTRIB)) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The 'description' attribute may not be null or empty!");
        }
        if (!this.checkString(CATEGORY_ATTRIB)) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The 'category' attribute may not be null or empty!");
        }
        if (!this.checkString(SUBCATEGORY_ATTRIB)) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The 'subcategory' attribute may not be null or empty!");
        }
        return true;
    }

    private boolean checkString(String attrName) {
        String input = this.getAttribute(attrName);
        return input != null && !"".equals(input);
    }

    public void setCategory(String category) {
        this.setAttribute(CATEGORY_ATTRIB, category);
    }

    public String getCategory() {
        return this.getAttribute(CATEGORY_ATTRIB);
    }

    public void setSubCategory(String subCategory) {
        this.setAttribute(SUBCATEGORY_ATTRIB, subCategory);
    }

    public String getSubCategory() {
        return this.getAttribute(SUBCATEGORY_ATTRIB);
    }

    public void setTitle(String title) {
        this.setAttribute(TITLE_ATTRIB, title);
    }

    public String getTitle() {
        return this.getAttribute(TITLE_ATTRIB);
    }

    public void setDescription(String description) {
        this.setAttribute(DESCRIPTION_ATTRIB, description);
    }

    public String getDescription() {
        return this.getAttribute(DESCRIPTION_ATTRIB);
    }

    public void removeAttribute(CharSequence attr) {
        this.attribs.remove(((Object)attr).toString());
    }
}

