/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.util;

import com.fengwenyi.javalib.util.Utils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class NetDataUtil {
    public static String get(String url, Map<String, String> header, Map<String, String> param) throws IOException {
        if (param != null) {
            url = url + "?" + Utils.getUrlParamsByMap(param);
        }
        HttpURLConnection httpUrlConn = NetDataUtil.httpUrlConn(url);
        httpUrlConn.setDoInput(true);
        httpUrlConn.setRequestMethod("GET");
        if (header != null) {
            NetDataUtil.header(header, httpUrlConn);
        }
        httpUrlConn.connect();
        return NetDataUtil.readIO(httpUrlConn);
    }

    public static String post(String url, Map<String, String> header, Map<String, String> params) throws IOException {
        HttpURLConnection httpUrlConn = NetDataUtil.httpUrlConn(url);
        httpUrlConn.setDoOutput(true);
        httpUrlConn.setRequestMethod("POST");
        if (header != null) {
            NetDataUtil.header(header, httpUrlConn);
        }
        httpUrlConn.connect();
        if (params != null) {
            PrintWriter pw = new PrintWriter(httpUrlConn.getOutputStream());
            String param = Utils.getUrlParamsByMap(params);
            pw.print(param);
            pw.flush();
            pw.close();
        }
        return NetDataUtil.readIO(httpUrlConn);
    }

    public static String put(String url, Map<String, String> header, Map<String, String> param) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(url).append("?");
        if (param != null) {
            stringBuilder.append(Utils.getUrlParamsByMap(param));
        }
        url = stringBuilder.substring(0, stringBuilder.length() - 1);
        HttpURLConnection httpUrlConn = NetDataUtil.httpUrlConn(url);
        httpUrlConn.setRequestMethod("PUT");
        httpUrlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        if (header != null) {
            NetDataUtil.header(header, httpUrlConn);
        }
        httpUrlConn.connect();
        return NetDataUtil.readIO(httpUrlConn);
    }

    public static String delete(String url, Map<String, String> header, Map<String, String> param) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(url).append("?");
        if (param != null) {
            stringBuilder.append(Utils.getUrlParamsByMap(param));
        }
        url = stringBuilder.substring(0, stringBuilder.length() - 1);
        HttpURLConnection httpUrlConn = NetDataUtil.httpUrlConn(url);
        httpUrlConn.setRequestMethod("DELETE");
        httpUrlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        if (header != null) {
            NetDataUtil.header(header, httpUrlConn);
        }
        httpUrlConn.connect();
        return NetDataUtil.readIO(httpUrlConn);
    }

    private static void header(Map<String, String> header, HttpURLConnection httpUrlConn) {
        if (!header.isEmpty()) {
            for (Map.Entry<String, String> map : header.entrySet()) {
                String headerKey = map.getKey();
                String headerValue = map.getValue();
                httpUrlConn.setRequestProperty(headerKey, headerValue);
            }
        }
    }

    private static HttpURLConnection httpUrlConn(String url) throws IOException {
        URL urlObject = new URL(url);
        HttpURLConnection httpUrlConn = (HttpURLConnection)urlObject.openConnection();
        httpUrlConn.setConnectTimeout(60000);
        httpUrlConn.setReadTimeout(600000);
        httpUrlConn.setUseCaches(false);
        httpUrlConn.setDoInput(true);
        return httpUrlConn;
    }

    private static String readIO(HttpURLConnection httpUrlConn) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpUrlConn.getInputStream(), "UTF-8"));
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line);
        }
        bufferedReader.close();
        httpUrlConn.disconnect();
        return stringBuilder.toString();
    }

    private String doPostByUrl(String uri, String param) throws IOException {
        String line;
        URL url = new URL(uri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(60000);
        connection.setReadTimeout(600000);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.connect();
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        out.writeBytes(param);
        out.flush();
        out.close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
        StringBuilder buffer = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
        }
        reader.close();
        connection.disconnect();
        return buffer.toString();
    }
}

