/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.util;

import com.fengwenyi.javalib.util.NetDataUtil;
import com.fengwenyi.javalib.util.StringUtil;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Utils {
    public static String getUrlParamsByMap(Map<String, String> data) throws UnsupportedEncodingException {
        if (data == null || data.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> i : data.entrySet()) {
            sb.append((Object)i.getKey()).append("=").append(URLEncoder.encode(i.getValue().toString(), "UTF-8")).append("&");
        }
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }

    public static Map<String, String> getUrlParams(String param) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtil.isNullStr(param)) {
            return map;
        }
        String[] params = param.split("&");
        for (int i = 0; i < params.length; ++i) {
            String[] p = params[i].split("=");
            if (p.length != 2) continue;
            map.put(p[0], p[1]);
        }
        return map;
    }

    public static JsonObject getIpInfo(String ip) throws IOException {
        String param = "?ip=" + ip;
        String ipInfoStr = NetDataUtil.get("http://ip.taobao.com/service/getIpInfo.php" + param, null, null);
        JsonObject ipInfoJsonObject = new JsonParser().parse(ipInfoStr).getAsJsonObject();
        return ipInfoJsonObject.get("data").getAsJsonObject();
    }

    public static String getPosition(String ip) throws IOException {
        JsonObject dataObject = Utils.getIpInfo(ip);
        String country = dataObject.get("country").getAsString();
        String area = dataObject.get("area").getAsString();
        String region = dataObject.get("region").getAsString();
        String city = dataObject.get("city").getAsString();
        String county = dataObject.get("county").getAsString();
        String isp = dataObject.get("isp").getAsString();
        return country + area + region + city + county + isp;
    }

    public static String getUUID() {
        String uuIdStr = UUID.randomUUID().toString();
        return uuIdStr.replaceAll("-", "");
    }
}

