/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.util;

import com.fengwenyi.javalib.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class DateTimeUtils {
    private static final int FIRST_DAY_OF_WEEK = 1;

    public static Date parse(String source, String format) throws ParseException {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.parse(source);
    }

    public static Long toLong(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public static String format(Object source, String format) {
        if (source == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(source);
    }

    public static Integer getYear(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static Integer getMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static Integer getDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static Integer getDayOfWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static Integer getDayOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static Integer getDayOfYear(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(6);
    }

    public static Integer getWeekOfYear(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(3);
    }

    public static Date getStartOfWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(1);
        calendar.set(7, 1);
        return calendar.getTime();
    }

    public static Date getEndOfWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(1);
        calendar.set(7, 7);
        return calendar.getTime();
    }

    public static Integer getRemainingDayOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        int days = DateTimeUtils.getDayNumOfMonth(date);
        int dayOfMonth = DateTimeUtils.getDayOfMonth(date);
        return days - dayOfMonth;
    }

    public static Integer getDayNumOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(5);
    }

    public static Date getFirstDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getLastDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static Date getFirstDateOfSeason(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeUtils.getFirstDateOfMonth(DateTimeUtils.getSeasonDate(date)[0]);
    }

    public static Date getLastDateOfSeason(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeUtils.getLastDateOfMonth(DateTimeUtils.getSeasonDate(date)[2]);
    }

    public static Integer getDayNumOfSeason(Date date) {
        Date[] seasonDates;
        if (date == null) {
            return null;
        }
        int day = 0;
        for (Date d : seasonDates = DateTimeUtils.getSeasonDate(date)) {
            day += DateTimeUtils.getDayOfMonth(d).intValue();
        }
        return day;
    }

    public static Integer getRemainingDayOfSeason(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeUtils.getDayNumOfSeason(date) - DateTimeUtils.getDayOfSeason(date);
    }

    public static Integer getDayOfSeason(Date date) {
        if (date == null) {
            return null;
        }
        int day = 0;
        Date[] seasonDates = DateTimeUtils.getSeasonDate(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        if (month == 0 || month == 3 || month == 6 || month == 9) {
            day = DateTimeUtils.getDayOfMonth(seasonDates[0]);
        } else if (month == 1 || month == 4 || month == 7 || month == 10) {
            day = DateTimeUtils.getDayOfMonth(seasonDates[0]) + DateTimeUtils.getDayOfMonth(seasonDates[1]);
        } else if (month == 2 || month == 5 || month == 8 || month == 11) {
            day = DateTimeUtils.getDayOfMonth(seasonDates[0]) + DateTimeUtils.getDayOfMonth(seasonDates[1]) + DateTimeUtils.getDayOfMonth(seasonDates[2]);
        }
        return day;
    }

    public static Date[] getSeasonDate(Date date) {
        Date[] season = new Date[3];
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int nSeason = DateTimeUtils.getQuarter(date);
        if (nSeason == 1) {
            c.set(2, 0);
            season[0] = c.getTime();
            c.set(2, 1);
            season[1] = c.getTime();
            c.set(2, 2);
            season[2] = c.getTime();
        } else if (nSeason == 2) {
            c.set(2, 3);
            season[0] = c.getTime();
            c.set(2, 4);
            season[1] = c.getTime();
            c.set(2, 5);
            season[2] = c.getTime();
        } else if (nSeason == 3) {
            c.set(2, 6);
            season[0] = c.getTime();
            c.set(2, 7);
            season[1] = c.getTime();
            c.set(2, 8);
            season[2] = c.getTime();
        } else if (nSeason == 4) {
            c.set(2, 9);
            season[0] = c.getTime();
            c.set(2, 10);
            season[1] = c.getTime();
            c.set(2, 11);
            season[2] = c.getTime();
        }
        return season;
    }

    public static Integer getQuarter(Date date) {
        if (date == null) {
            return null;
        }
        int season = 1;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        switch (month) {
            case 3: 
            case 4: 
            case 5: {
                season = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                season = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                season = 4;
            }
        }
        return season;
    }

    public static String descPastTime(Date source) {
        if (source == null) {
            return null;
        }
        long nowTime = System.currentTimeMillis();
        String msg = "";
        long dateDiff = nowTime - source.getTime();
        if (dateDiff >= 0L) {
            long dateTemp1 = dateDiff / 1000L;
            long dateTemp2 = dateTemp1 / 60L;
            long dateTemp3 = dateTemp2 / 60L;
            long dateTemp4 = dateTemp3 / 24L;
            long dateTemp5 = dateTemp4 / 30L;
            long dateTemp6 = dateTemp5 / 12L;
            msg = dateTemp6 > 0L ? dateTemp6 + "\u5e74\u524d" : (dateTemp5 > 0L ? dateTemp5 + "\u4e2a\u6708\u524d" : (dateTemp4 > 0L ? dateTemp4 + "\u5929\u524d" : (dateTemp3 > 0L ? dateTemp3 + "\u5c0f\u65f6\u524d" : (dateTemp2 > 0L ? dateTemp2 + "\u5206\u949f\u524d" : (dateTemp1 > 0L ? dateTemp1 + "\u79d2\u524d" : "\u521a\u521a")))));
        }
        return msg;
    }

    public static long differMillis(Instant start, Instant end) {
        return Duration.between(start, end).toMillis();
    }

    public static long differSeconds(Instant start, Instant end) {
        return Duration.between(start, end).getSeconds();
    }

    public static long differMinutes(Instant start, Instant end) {
        return Duration.between(start, end).toMinutes();
    }

    public static long differHours(Instant start, Instant end) {
        return Duration.between(start, end).toHours();
    }

    public static long differDays(Instant start, Instant end) {
        return Duration.between(start, end).toDays();
    }

    public static String format(Instant instant, String format) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return localDateTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static Instant parseDate(String source) {
        LocalDate date = LocalDate.parse(source);
        return date.atStartOfDay(ZoneId.systemDefault()).toInstant();
    }

    public static Instant parseDateTime(String source, String format) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        LocalDateTime dateTime = LocalDateTime.parse(source, dateTimeFormatter);
        return dateTime.atZone(ZoneOffset.systemDefault()).toInstant();
    }
}

