/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.util;

import com.fengwenyi.javalib.util.ParamUtils;
import com.fengwenyi.javalib.util.StringUtils;
import java.io.IOException;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUtils {
    public static String postForm(String url, Map<String, String> paramMap) throws IOException {
        FormBody.Builder formBuilder = new FormBody.Builder();
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            formBuilder.add(key, value);
        }
        FormBody formBody = formBuilder.build();
        OkHttpClient okHttpClient = new OkHttpClient.Builder().build();
        Request request = new Request.Builder().url(url).post((RequestBody)formBody).build();
        Response response = okHttpClient.newCall(request).execute();
        assert (response.body() != null);
        return response.body().string();
    }

    public static String postJson(String url, String jsonStr) throws IOException {
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        OkHttpClient okHttpClient = new OkHttpClient();
        Request request = new Request.Builder().url(url).post(RequestBody.create((MediaType)mediaType, (String)jsonStr)).build();
        Response response = okHttpClient.newCall(request).execute();
        assert (response.body() != null);
        return response.body().string();
    }

    public static String get(String url, Map<String, String> paramMap) throws IOException {
        String param = ParamUtils.getUrlParamsByMap(paramMap);
        if (StringUtils.isNotEmpty(param)) {
            url = url + "?" + param;
        }
        return HttpUtils.get(url);
    }

    public static String get(String url) throws IOException {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().build();
        Request request = new Request.Builder().url(url).get().build();
        Response response = okHttpClient.newCall(request).execute();
        assert (response.body() != null);
        return response.body().string();
    }
}

