/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class IpUtils {
    private static final String USER_AGENT_KEY = "User-Agent";
    private static final String USER_AGENT_VALUE = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36 JavaLib";

    public static String getPosition(String ip) throws IOException {
        JSONObject jsonObject = IpUtils.getIpInfo(ip);
        if (jsonObject != null) {
            String country = jsonObject.get((Object)"country").toString();
            String area = jsonObject.get((Object)"area").toString();
            String region = jsonObject.get((Object)"region").toString();
            String city = jsonObject.get((Object)"city").toString();
            String county = jsonObject.get((Object)"county").toString();
            String isp = jsonObject.get((Object)"isp").toString();
            return country + area + region + city + county + isp;
        }
        return null;
    }

    public static JSONObject getIpInfo(String ip) throws IOException {
        String param = "?ip=" + ip;
        String ipInfoStr = IpUtils.getIpInfoByIp("http://ip.taobao.com/service/getIpInfo.php" + param);
        JSONObject jsonObject = JSON.parseObject((String)ipInfoStr);
        Integer code = (Integer)jsonObject.get((Object)"code");
        if (code == 0) {
            return jsonObject.getJSONObject("data");
        }
        return null;
    }

    private static String getIpInfoByIp(String url) throws IOException {
        OkHttpClient okHttpClient = new OkHttpClient();
        Request request = new Request.Builder().url(url).get().removeHeader(USER_AGENT_KEY).addHeader(USER_AGENT_KEY, USER_AGENT_VALUE).build();
        Call call = okHttpClient.newCall(request);
        Response response = call.execute();
        return response.body() == null ? "" : response.body().string();
    }
}

