/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.util;

import com.fengwenyi.javalib.third.Base64;
import com.fengwenyi.javalib.util.HexUtils;
import com.fengwenyi.javalib.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSAUtils {
    private static final String RSA = "RSA";
    private static int LENGTH = 512;

    public static String[] getKey(int keySize) throws NoSuchAlgorithmException {
        LENGTH = keySize;
        return RSAUtils.commonKey(LENGTH);
    }

    public static String[] getKey() throws NoSuchAlgorithmException {
        return RSAUtils.commonKey(LENGTH);
    }

    public static String privateKeyEncrypt(String key, String plainText) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException, InvalidKeyException {
        PrivateKey privateKey = RSAUtils.commonGetPrivatekeyByText(key);
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, privateKey);
        byte[] result = cipher.doFinal(plainText.getBytes("UTF-8"));
        return Base64.byteArrayToBase64(result);
    }

    public static String publicKeyDecrypt(String key, String cipherText) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        PublicKey publicKey = RSAUtils.commonGetPublickeyByText(key);
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, publicKey);
        byte[] result = cipher.doFinal(Base64.base64ToByteArray(cipherText));
        return new String(result);
    }

    public static String publicKeyEncrypt(String key, String plainText) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException {
        PublicKey publicKey = RSAUtils.commonGetPublickeyByText(key);
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, publicKey);
        byte[] result = cipher.doFinal(plainText.getBytes("UTF-8"));
        return Base64.byteArrayToBase64(result);
    }

    public static String privateKeyDecrypt(String key, String cipherText) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        PrivateKey privateKey = RSAUtils.commonGetPrivatekeyByText(key);
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, privateKey);
        byte[] result = cipher.doFinal(Base64.base64ToByteArray(cipherText));
        return new String(result);
    }

    private static String[] commonKey(int size) throws NoSuchAlgorithmException {
        String[] keys = new String[2];
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA);
        keyPairGenerator.initialize(size);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
        keys[0] = Base64.byteArrayToBase64(rsaPrivateKey.getEncoded());
        keys[1] = Base64.byteArrayToBase64(rsaPublicKey.getEncoded());
        return keys;
    }

    private static PublicKey commonGetPublickeyByText(String keyText) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyBytes = Base64.base64ToByteArray(keyText);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        return keyFactory.generatePublic(x509KeySpec);
    }

    private static PrivateKey commonGetPrivatekeyByText(String keyText) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyBytes = Base64.base64ToByteArray(keyText);
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        return keyFactory.generatePrivate(pkcs8EncodedKeySpec);
    }

    public static String sign(String content, String algorithm, String privateKey, String charset) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        Signature signTool = Signature.getInstance(algorithm);
        PrivateKey key = RSAUtils.commonGetPrivatekeyByText(privateKey);
        signTool.initSign(key);
        if (StringUtils.isEmpty(charset)) {
            signTool.update(content.getBytes());
        } else {
            signTool.update(content.getBytes(charset));
        }
        byte[] signBytes = signTool.sign();
        return HexUtils._2_16(signBytes);
    }

    public static boolean verify(String content, String signature, String algorithm, String publicKey, String charset) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        Signature signTool = Signature.getInstance(algorithm);
        PublicKey key = RSAUtils.commonGetPublickeyByText(publicKey);
        signTool.initVerify(key);
        if (StringUtils.isEmpty(charset)) {
            signTool.update(content.getBytes());
        } else {
            signTool.update(content.getBytes(charset));
        }
        return signTool.verify(HexUtils._16_2(signature));
    }
}

