/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.util;

import java.util.regex.Pattern;

public class StringUtils {
    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        if ("".equals(str.trim())) {
            return true;
        }
        return str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String autoFill(Integer source, Integer length) {
        if (source == null || length == null || (source + "").length() >= length) {
            return source + "";
        }
        return String.format("%0" + length + "d", source);
    }

    public static String autoFill(String source, Integer length, String str, Boolean isRight) {
        if (source == null || length == null || (source + "").length() >= length) {
            return source + "";
        }
        if (StringUtils.isEmpty(str)) {
            str = "0";
        }
        if (isRight == null) {
            isRight = false;
        }
        int count = (source + "").length();
        StringBuilder sb = new StringBuilder(length);
        if (isRight.booleanValue()) {
            sb.append(source);
        }
        int size = length - count;
        for (int i = 0; i < size; ++i) {
            sb.append(str);
        }
        if (!isRight.booleanValue()) {
            sb.append(source);
        }
        return sb.toString();
    }

    public static boolean hasOnlyNum(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public static String getRandomString(int length) {
        StringBuilder result = new StringBuilder();
        char[] str = "0123456789abcdefghijkmlnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        for (int i = 0; i < length; ++i) {
            int index = (int)(Math.random() * (double)str.length);
            result.append(str[index]);
        }
        return result.toString();
    }
}

