/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.image;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;

public class ImageUtils {
    public static BufferedImage compress(String path, int width, int height) {
        try {
            return Thumbnails.of((String[])new String[]{path}).size(width, height).asBufferedImage();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static BufferedImage compress(File file, int width, int height) {
        try {
            return Thumbnails.of((File[])new File[]{file}).size(width, height).asBufferedImage();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static BufferedImage compress(URL url, int width, int height) {
        try {
            return Thumbnails.of((URL[])new URL[]{url}).size(width, height).asBufferedImage();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void compress(String path, String thumbnail, int width, int height) {
        try {
            Thumbnails.of((String[])new String[]{path}).size(width, height).toFile(thumbnail);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void compress(URL url, String thumbnail, int scale) {
        try {
            Thumbnails.of((URL[])new URL[]{url}).scale((double)scale).toFile(thumbnail);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static BufferedImage clipping(String filePath, int width, int height) throws Exception {
        BufferedImage buffer = ImageIO.read(new File(filePath));
        int w = buffer.getWidth();
        int h = buffer.getHeight();
        double ratiox = 1.0;
        double ratioy = 1.0;
        ratiox = (double)w * ratiox / (double)width;
        ratioy = (double)h * ratioy / (double)height;
        ratiox = ratiox >= 1.0 ? (ratioy < 1.0 ? (double)height * 1.0 / (double)h : (ratiox > ratioy ? (double)height * 1.0 / (double)h : (double)width * 1.0 / (double)w)) : (ratioy < 1.0 ? (ratiox > ratioy ? (double)height * 1.0 / (double)h : (double)width * 1.0 / (double)w) : (double)width * 1.0 / (double)w);
        AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratiox, ratiox), null);
        buffer = op.filter(buffer, null);
        buffer = buffer.getSubimage((buffer.getWidth() - width) / 2, (buffer.getHeight() - height) / 2, width, height);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)buffer, "jpg", out);
        return buffer;
    }
}

