/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.http;

import com.fengwenyi.javalib.collection.MapUtils;
import com.fengwenyi.javalib.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class Request {
    private String url;
    private Method method;
    private String param;
    private Util util = Util.JDK;

    public static Request create(String url, Method method, String param) {
        Request request = new Request();
        request.setUrl(url);
        request.setMethod(method);
        request.setParam(param);
        return request;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String getParam() {
        return this.param;
    }

    public Request setParam(String param) {
        this.param = param;
        return this;
    }

    public Request setParam(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            return this;
        }
        StringJoiner stringJoiner = new StringJoiner("&", "", "");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!StringUtils.isNotEmpty(entry.getKey())) continue;
            stringJoiner.add(entry.getKey() + "=" + entry.getValue());
        }
        String param = stringJoiner.toString();
        return this.setParam(param);
    }

    public Util getUtil() {
        return this.util;
    }

    public void setUtil(Util util) {
        this.util = util;
    }

    public static class Option {
        private Integer connectTimeoutSecond = 5;
        private Integer readTimeoutSecond = 45;
        private Map<String, String> headers = new HashMap<String, String>();
        private SSLSocketFactory sslContextFactory;
        private HostnameVerifier hostnameVerifier;
        private LogLevel logLevel;

        public static Option create(Integer connectTimeoutSecond, Integer readTimeoutSecond) {
            Option option = new Option();
            Optional.ofNullable(connectTimeoutSecond).ifPresent(option::setConnectTimeoutSecond);
            Optional.ofNullable(readTimeoutSecond).ifPresent(option::setReadTimeoutSecond);
            return option;
        }

        public static Option create(Integer connectTimeoutSecond, Integer readTimeoutSecond, Map<String, String> headers) {
            Option option = new Option();
            Optional.ofNullable(connectTimeoutSecond).ifPresent(option::setConnectTimeoutSecond);
            Optional.ofNullable(readTimeoutSecond).ifPresent(option::setReadTimeoutSecond);
            Optional.ofNullable(headers).ifPresent(option::setHeaders);
            return option;
        }

        public void setSslContextFactory(SSLSocketFactory sslContextFactory) {
            this.sslContextFactory = sslContextFactory;
        }

        public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
        }

        public Integer getConnectTimeoutSecond() {
            return this.connectTimeoutSecond;
        }

        public void setConnectTimeoutSecond(Integer connectTimeoutSecond) {
            this.connectTimeoutSecond = connectTimeoutSecond;
        }

        public Integer getReadTimeoutSecond() {
            return this.readTimeoutSecond;
        }

        public void setReadTimeoutSecond(Integer readTimeoutSecond) {
            this.readTimeoutSecond = readTimeoutSecond;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public SSLSocketFactory getSslContextFactory() {
            return this.sslContextFactory;
        }

        public HostnameVerifier getHostnameVerifier() {
            return this.hostnameVerifier;
        }

        public LogLevel getLogLevel() {
            return this.logLevel;
        }

        public void setLogLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
        }
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        ERROR;

    }

    public static enum Util {
        JDK;

    }

    public static enum Method {
        GET,
        POST,
        PUT,
        PATCH,
        DELETE;

    }
}

