/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.http.client.impl;

import com.fengwenyi.javalib.collection.MapUtils;
import com.fengwenyi.javalib.file.IOUtils;
import com.fengwenyi.javalib.http.Request;
import com.fengwenyi.javalib.http.Response;
import com.fengwenyi.javalib.http.client.HttpClient;
import com.fengwenyi.javalib.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class JdkHttpClient
implements HttpClient {
    /*
     * WARNING - void declaration
     */
    @Override
    public Response execute(Request request, Request.Option option) throws IOException {
        void var7_14;
        URL url;
        HttpURLConnection connection;
        String requestUrl = request.getUrl();
        if (Request.Method.GET == request.getMethod() && StringUtils.isNotEmpty(request.getParam())) {
            requestUrl = requestUrl + "?" + request.getParam();
        }
        if ((connection = (HttpURLConnection)(url = new URL(requestUrl)).openConnection()) instanceof HttpsURLConnection) {
            void var7_9;
            HttpsURLConnection sslCon = (HttpsURLConnection)connection;
            SSLSocketFactory sSLSocketFactory = option.getSslContextFactory();
            HostnameVerifier hostnameVerifier = option.getHostnameVerifier();
            if (Objects.isNull(sSLSocketFactory)) {
                SSLSocketFactory sSLSocketFactory2 = JdkHttpClient.defaultSSLSocketFactory();
            }
            if (Objects.isNull(hostnameVerifier)) {
                hostnameVerifier = (s, sslSession) -> true;
            }
            sslCon.setSSLSocketFactory((SSLSocketFactory)var7_9);
            sslCon.setHostnameVerifier(hostnameVerifier);
        }
        connection.setRequestMethod(request.getMethod().name());
        if (MapUtils.isNotEmpty(option.getHeaders())) {
            for (Map.Entry entry : option.getHeaders().entrySet()) {
                if (!Objects.nonNull(entry) || !StringUtils.isNotEmpty((String)entry.getKey())) continue;
                connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(option.getConnectTimeoutSecond().intValue()));
        connection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(option.getReadTimeoutSecond().intValue()));
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.connect();
        if (Request.Method.POST == request.getMethod() && StringUtils.isNotEmpty(request.getParam())) {
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(request.getParam().getBytes(StandardCharsets.UTF_8));
            outputStream.close();
        }
        Response response = new Response();
        response.setCode(connection.getResponseCode());
        response.setMsg(connection.getResponseMessage());
        if (connection.getResponseCode() == 200) {
            InputStream inputStream = connection.getInputStream();
        } else {
            InputStream inputStream = connection.getErrorStream();
        }
        String body = IOUtils.readAndClose((InputStream)var7_14);
        response.setBody(body);
        connection.disconnect();
        return response;
    }

    private static SSLSocketFactory defaultSSLSocketFactory() {
        SSLContext ctx;
        try {
            ctx = SSLContext.getInstance("SSL");
            TrustManager[] trustManagers = new TrustManager[]{new DefaultTrustMannager()};
            ctx.init(null, trustManagers, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return ctx.getSocketFactory();
    }

    private static final class DefaultTrustMannager
    implements X509TrustManager {
        private DefaultTrustMannager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

