/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.http;

import com.fengwenyi.javalib.http.Request;
import com.fengwenyi.javalib.http.Response;
import com.fengwenyi.javalib.http.client.HttpClient;
import com.fengwenyi.javalib.http.client.HttpClientFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class HttpUtils {
    public static String get(String url, String param, Map<String, String> headers) {
        try {
            Request request = HttpUtils.buildRequest(url, param);
            request.setMethod(Request.Method.GET);
            Request.Option option = HttpUtils.buildOption(null, null, headers);
            return HttpUtils.execute(request, option);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String get(String url, String param) {
        return HttpUtils.get(url, "", null);
    }

    public static String get(String url) {
        return HttpUtils.get(url, "");
    }

    public static String post(String url, String param, Map<String, String> headers) {
        try {
            Request request = HttpUtils.buildRequest(url, param);
            request.setMethod(Request.Method.POST);
            Request.Option option = HttpUtils.buildOption(null, null, headers);
            return HttpUtils.execute(request, option);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String post(String url, String param) {
        return HttpUtils.post(url, param, null);
    }

    public static Request buildRequest(String url, String param) {
        return Request.create(url, null, param);
    }

    public static Request buildGetRequest(String url, String param) {
        return Request.create(url, Request.Method.GET, param);
    }

    public static Request buildPostRequest(String url, String param) {
        return Request.create(url, Request.Method.POST, param);
    }

    public static Request.Option buildOption(Integer connectTimeoutSecond, Integer readTimeoutSecond, Map<String, String> headers) {
        return Request.Option.create(connectTimeoutSecond, readTimeoutSecond, headers);
    }

    public static String execute(Request request, Request.Option option) throws IOException {
        HttpUtils.check(request, option);
        HttpClient httpClient = HttpClientFactory.get(request.getUtil());
        Response response = httpClient.execute(request, option);
        return HttpUtils.handleResponse(response);
    }

    private static String handleResponse(Response response) throws IOException {
        if (Objects.isNull(response)) {
            return "";
        }
        String data = response.getBody();
        if (response.getCode() == 200) {
            return data;
        }
        throw new RuntimeException(data);
    }

    private static void check(Request request, Request.Option option) {
        HttpUtils.notNull(request, "request must be not null");
        HttpUtils.notNull(option, "option must be not null");
        HttpUtils.notNull(request.getUrl(), "url must be not null");
        HttpUtils.notNull((Object)request.getMethod(), "method must be not null");
        HttpUtils.notNull((Object)request.getUtil(), "http util must be not null");
    }

    private static void notNull(Object param, String message) {
        if (Objects.isNull(param)) {
            throw new RuntimeException(message);
        }
    }
}

