/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.convert;

import com.fengwenyi.javalib.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NamingUtils {
    private static final Pattern HUMP_PATTERN = Pattern.compile("[A-Z]");
    private static final Pattern UNDERLINE_PATTERN = Pattern.compile("_(\\w)");

    public static String humpToMidline(String name) {
        if (StringUtils.isEmpty(name)) {
            return "";
        }
        Matcher matcher = HUMP_PATTERN.matcher(name);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "-" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String humpToUnderline(String name) {
        if (StringUtils.isEmpty(name)) {
            return "";
        }
        Matcher matcher = HUMP_PATTERN.matcher(name);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String underlineToHump(String name) {
        if (StringUtils.isEmpty(name)) {
            return "";
        }
        name = name.toLowerCase();
        Matcher matcher = UNDERLINE_PATTERN.matcher(name);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

