/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.handle;

import com.fengwenyi.javalib.collection.CollectionUtils;
import com.fengwenyi.javalib.util.StringUtils;

public class StarHandleUtils {
    public static String ip(String ip) {
        if (StringUtils.isEmpty(ip)) {
            return "";
        }
        String[] array = ip.split("\\.");
        if (CollectionUtils.isNotEmpty(array) && array.length == 4) {
            return String.format("%s.%s.*.*", array[0], array[1]);
        }
        return "";
    }

    public static String phone(String phone) {
        if (StringUtils.isEmpty(phone)) {
            return "";
        }
        if (phone.length() == 11) {
            String left = StringUtils.getLeft(phone, 3);
            String right = StringUtils.getRight(phone, 4);
            String star = StringUtils.generateStar(4);
            return left + star + right;
        }
        return "";
    }

    public static String email(String email) {
        if (StringUtils.isEmpty(email)) {
            return "";
        }
        int index = email.lastIndexOf("@");
        if (index > 0) {
            int indexLeft = index == 1 ? 0 : 1;
            String right = StringUtils.getRight(email, email.length() - index);
            String left = StringUtils.getLeft(email, indexLeft);
            String star = StringUtils.generateStar(index - indexLeft);
            return left + star + right;
        }
        return "";
    }

    public static String idCardNo(String idCardNo) {
        return StarHandleUtils.idCardNo(idCardNo, 3, 4);
    }

    public static String idCardNo(String idCardNo, int leftLength, int rightLength) {
        if (StringUtils.isEmpty(idCardNo)) {
            return "";
        }
        if (idCardNo.length() <= leftLength + rightLength) {
            return "";
        }
        String leftString = StringUtils.getLeft(idCardNo, leftLength);
        String rightString = StringUtils.getRight(idCardNo, rightLength);
        int starLength = idCardNo.length() - leftLength - rightLength;
        String starString = StringUtils.generateStar(starLength);
        return leftString + starString + rightString;
    }

    public static String password() {
        return StringUtils.generateStar(32);
    }

    public static String password(int len) {
        return StringUtils.generateStar(len);
    }

    public static String realName(String realName) {
        if (StringUtils.isEmpty(realName)) {
            return "";
        }
        if (realName.length() == 2) {
            String right = StringUtils.getRight(realName, 1);
            String star = StringUtils.generateStar(1);
            return star + right;
        }
        if (realName.length() > 2) {
            String left = StringUtils.getLeft(realName, 1);
            String right = StringUtils.getRight(realName, 1);
            String star = StringUtils.generateStar(realName.length() - 2);
            return left + star + right;
        }
        return StringUtils.generateStar(1);
    }
}

