/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.http.client.impl;

import com.fengwenyi.javalib.collection.MapUtils;
import com.fengwenyi.javalib.convert.JsonUtils;
import com.fengwenyi.javalib.http.Request;
import com.fengwenyi.javalib.http.Response;
import com.fengwenyi.javalib.http.client.HttpClient;
import java.io.IOException;
import java.rmi.RemoteException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public class OkHttpClient
implements HttpClient {
    @Override
    public Response execute(Request request, Request.Option option) throws IOException {
        if (Request.Method.GET == request.getMethod()) {
            return this.get(request, option);
        }
        if (Request.Method.POST == request.getMethod()) {
            return this.post(request, option);
        }
        throw new RemoteException("request method '" + request.getMethod().name() + "' not implemented");
    }

    private okhttp3.OkHttpClient client(Request.Option option) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (Objects.nonNull(option)) {
            Integer readTimeoutSecond;
            Integer connectTimeoutSecond = this.getTimeoutSecond(option.getConnectTimeoutSecond());
            if (Objects.nonNull(connectTimeoutSecond)) {
                builder.connectTimeout(Duration.ofSeconds(connectTimeoutSecond.intValue()));
            }
            if (Objects.nonNull(readTimeoutSecond = this.getTimeoutSecond(option.getReadTimeoutSecond()))) {
                builder.readTimeout(Duration.ofSeconds(readTimeoutSecond.intValue()));
            }
        }
        return builder.build();
    }

    private Response get(Request request, Request.Option option) {
        okhttp3.OkHttpClient client = this.client(option);
        okhttp3.Request httpRequest = this.buildRequest(this.getHttpUrl(request), option.getHeaders(), request.getMethod(), null);
        return this.call(client, httpRequest);
    }

    private Response post(Request request, Request.Option option) {
        okhttp3.OkHttpClient client = this.client(option);
        Request.ParamFormat paramFormat = request.getParamFormat();
        Map<String, Object> param = request.getParam();
        RequestBody requestBody = null;
        if (MapUtils.isNotEmpty(param)) {
            if (param.containsKey("__default__")) {
                String paramStr = param.get("__default__") + "";
                if (Request.ParamFormat.JSON == paramFormat) {
                    requestBody = this.buildJsonRequestBody(paramStr);
                }
            } else if (Request.ParamFormat.JSON == paramFormat) {
                requestBody = this.buildJsonRequestBody(JsonUtils.convertString(param));
            } else if (Request.ParamFormat.FORM == paramFormat) {
                requestBody = this.buildFormRequestBody(param);
            }
        }
        okhttp3.Request httpRequest = this.buildRequest(this.getHttpUrl(request), option.getHeaders(), request.getMethod(), requestBody);
        return this.call(client, httpRequest);
    }

    private RequestBody buildJsonRequestBody(String param) {
        return RequestBody.create((String)param, (MediaType)MediaType.parse((String)"application/json"));
    }

    private RequestBody buildFormRequestBody(Map<String, Object> param) {
        FormBody.Builder builder = new FormBody.Builder();
        if (MapUtils.isNotEmpty(param)) {
            for (Map.Entry<String, Object> entry : param.entrySet()) {
                builder.add(entry.getKey(), entry.getValue() + "");
            }
        }
        return builder.build();
    }

    private okhttp3.Request buildRequest(HttpUrl httpUrl, Map<String, String> headers, Request.Method requestMethod, RequestBody requestBody) {
        Request.Builder builder = new Request.Builder();
        builder.url(httpUrl);
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (Objects.nonNull(requestBody)) {
            if (Request.Method.POST == requestMethod) {
                builder.post(requestBody);
            } else if (Request.Method.PUT == requestMethod) {
                builder.put(requestBody);
            }
        }
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response call(okhttp3.OkHttpClient client, okhttp3.Request request) {
        Call call = client.newCall(request);
        try (okhttp3.Response httpResponse = call.execute();){
            Response response = this.convertResponse(httpResponse);
            return response;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Response convertResponse(okhttp3.Response httpResponse) throws IOException {
        if (Objects.isNull(httpResponse)) {
            throw new RuntimeException("http response null");
        }
        Response response = new Response();
        response.setCode(httpResponse.code());
        response.setMsg(httpResponse.message());
        ResponseBody responseBody = httpResponse.body();
        if (Objects.nonNull(responseBody)) {
            response.setBody(responseBody.string());
        }
        return response;
    }

    private HttpUrl getHttpUrl(Request request) {
        HttpUrl.Builder builder = HttpUrl.get((String)request.getUrl()).newBuilder();
        if (Request.Method.GET == request.getMethod() && MapUtils.isNotEmpty(request.getParam())) {
            if (request.getParam().containsKey("__default__")) {
                builder.addPathSegment(request.getParam().get("__default__") + "");
            } else {
                for (Map.Entry<String, Object> entry : request.getParam().entrySet()) {
                    builder.addQueryParameter(entry.getKey(), entry.getValue() + "");
                }
            }
        }
        return builder.build();
    }
}

