/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.bean;

import com.fengwenyi.javalib.convert.JsonUtils;
import com.fengwenyi.javalib.jk.IGetter;
import com.fengwenyi.javalib.jk.ISetter;
import com.fengwenyi.javalib.util.StringUtils;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;

public class BeanUtils {
    private static final String[] GET_SET_PREFIX = new String[]{"get", "is", "set"};

    public static <T> T copy(Object source, Class<T> targetClazz) {
        String jsonString = JsonUtils.convertString(source);
        return JsonUtils.convertObject(jsonString, targetClazz);
    }

    public static <T> String getFieldNameByGet(IGetter<T, Object> fn) {
        SerializedLambda lambda = BeanUtils.getSerializedLambda(fn);
        String methodName = lambda.getImplMethodName();
        return BeanUtils.getFieldNameByMethodName(methodName);
    }

    public static <T, U> String getFieldNameBySet(ISetter<T, U> fn) {
        SerializedLambda lambda = BeanUtils.getSerializedLambda(fn);
        String methodName = lambda.getImplMethodName();
        return BeanUtils.getFieldNameByMethodName(methodName);
    }

    private static SerializedLambda getSerializedLambda(Serializable fn) {
        SerializedLambda lambda = null;
        try {
            Method method = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            lambda = (SerializedLambda)method.invoke((Object)fn, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lambda;
    }

    private static String getFieldNameByMethodName(String methodName) {
        String prefix = BeanUtils.getGetSetMethodPrefix(methodName);
        if (StringUtils.isEmpty(prefix)) {
            System.err.println("\u65e0\u6548\u7684\u65b9\u6cd5: " + methodName);
            return "";
        }
        return StringUtils.lowerCaseFirst(StringUtils.substringAfter(methodName, prefix));
    }

    private static String getGetSetMethodPrefix(String methodName) {
        for (String prefix : GET_SET_PREFIX) {
            if (!methodName.startsWith(prefix)) continue;
            return prefix;
        }
        return null;
    }
}

