/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.http.client.impl;

import com.fengwenyi.javalib.collection.MapUtils;
import com.fengwenyi.javalib.convert.JsonUtils;
import com.fengwenyi.javalib.file.IOUtils;
import com.fengwenyi.javalib.http.Request;
import com.fengwenyi.javalib.http.Response;
import com.fengwenyi.javalib.http.client.HttpClient;
import com.fengwenyi.javalib.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class JdkHttpClient
implements HttpClient {
    /*
     * WARNING - void declaration
     */
    @Override
    public Response execute(Request request, Request.Option option) throws IOException {
        void var7_22;
        String requestUrl = this.getUrl(request);
        URL url = new URL(requestUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (connection instanceof HttpsURLConnection) {
            void var7_11;
            void var7_9;
            HttpsURLConnection sslCon = (HttpsURLConnection)connection;
            Object var7_7 = null;
            HostnameVerifier hostnameVerifier = null;
            if (Objects.nonNull(option)) {
                SSLSocketFactory sSLSocketFactory = option.getSslContextFactory();
                hostnameVerifier = option.getHostnameVerifier();
            }
            if (Objects.isNull(var7_9)) {
                SSLSocketFactory sSLSocketFactory = JdkHttpClient.defaultSSLSocketFactory();
            }
            if (Objects.isNull(hostnameVerifier)) {
                hostnameVerifier = (s, sslSession) -> true;
            }
            sslCon.setSSLSocketFactory((SSLSocketFactory)var7_11);
            sslCon.setHostnameVerifier(hostnameVerifier);
        }
        connection.setRequestMethod(request.getMethod().name());
        if (Objects.nonNull(option) && MapUtils.isNotEmpty(option.getHeaders())) {
            for (Map.Entry entry : option.getHeaders().entrySet()) {
                if (!Objects.nonNull(entry) || !StringUtils.isNotEmpty((String)entry.getKey())) continue;
                connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (Objects.nonNull(option)) {
            Integer n;
            Integer connectTimeoutSecond = this.getTimeoutSecond(option.getConnectTimeoutSecond());
            if (Objects.nonNull(connectTimeoutSecond)) {
                connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(connectTimeoutSecond.intValue()));
            }
            if (Objects.nonNull(n = this.getTimeoutSecond(option.getReadTimeoutSecond()))) {
                connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(n.intValue()));
            }
        }
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.connect();
        if (Request.Method.POST == request.getMethod() && MapUtils.isNotEmpty(request.getParam())) {
            void var7_18;
            OutputStream outputStream = connection.getOutputStream();
            if (Request.ParamFormat.JSON == request.getParamFormat()) {
                String string = this.getParamJson(request);
            } else {
                String string = this.getParamForm(request);
            }
            outputStream.write(var7_18.getBytes(StandardCharsets.UTF_8));
            outputStream.close();
        }
        Response response = new Response();
        response.setCode(connection.getResponseCode());
        response.setMsg(connection.getResponseMessage());
        if (connection.getResponseCode() == 200) {
            InputStream inputStream = connection.getInputStream();
        } else {
            InputStream inputStream = connection.getErrorStream();
        }
        String body = IOUtils.readAndClose((InputStream)var7_22);
        response.setBody(body);
        connection.disconnect();
        return response;
    }

    private static SSLSocketFactory defaultSSLSocketFactory() {
        SSLContext ctx;
        try {
            ctx = SSLContext.getInstance("SSL");
            TrustManager[] trustManagers = new TrustManager[]{new DefaultTrustMannager()};
            ctx.init(null, trustManagers, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return ctx.getSocketFactory();
    }

    private String getUrl(Request request) {
        StringBuilder requestUrl = new StringBuilder(request.getUrl());
        if (Request.Method.GET == request.getMethod() && MapUtils.isNotEmpty(request.getParam())) {
            requestUrl.append("?").append(this.getParamForm(request));
        }
        return requestUrl.toString();
    }

    private String getParamJson(Request request) {
        if (request.getParam().containsKey("__default__")) {
            return request.getParam().get("__default__") + "";
        }
        return JsonUtils.convertString(request.getParam());
    }

    private String getParamForm(Request request) {
        if (request.getParam().containsKey("__default__")) {
            return request.getParam().get("__default__") + "";
        }
        StringBuilder param = new StringBuilder();
        for (Map.Entry<String, Object> entry : request.getParam().entrySet()) {
            param.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        return param.substring(0, param.length() - 1);
    }

    private static final class DefaultTrustMannager
    implements X509TrustManager {
        private DefaultTrustMannager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

