/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.example.common;

import com.firefly.$;
import com.firefly.utils.CollectionUtils;
import com.firefly.utils.StringUtils;
import com.firefly.utils.log.LogFormatter;
import com.firefly.utils.log.LogItem;
import com.firefly.utils.time.SafeSimpleDateFormat;
import java.util.Map;

public class ExampleLogFormatter
implements LogFormatter {
    public String format(LogItem logItem) {
        String logStr = logItem.getLevel() + " " + SafeSimpleDateFormat.defaultDateFormat.format(logItem.getDate());
        if (!CollectionUtils.isEmpty((Map)logItem.getMdcData())) {
            logStr = logStr + " " + logItem.getMdcData();
        }
        if (StringUtils.hasText((String)logItem.getClassName())) {
            String[] arr = $.string.split((String)logItem.getClassName(), (char)'.');
            logStr = logStr + " " + arr[arr.length - 1];
        }
        if (StringUtils.hasText((String)logItem.getThreadName())) {
            logStr = logStr + " " + logItem.getThreadName();
        }
        if (logItem.getStackTraceElement() != null) {
            logStr = logStr + " " + logItem.getStackTraceElement();
        }
        logStr = logStr + " -> " + logItem.renderContentTemplate();
        return logStr;
    }
}

