/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.example.kotlin.coffee.store.service.impl;

import com.firefly.annotation.Component;
import com.firefly.annotation.Inject;
import com.firefly.example.kotlin.coffee.store.dao.InventoryDAO;
import com.firefly.example.kotlin.coffee.store.dao.OrderDAO;
import com.firefly.example.kotlin.coffee.store.dao.ProductDAO;
import com.firefly.example.kotlin.coffee.store.model.Order;
import com.firefly.example.kotlin.coffee.store.model.Product;
import com.firefly.example.kotlin.coffee.store.service.OrderService;
import com.firefly.example.kotlin.coffee.store.service.impl.OrderServiceImpl;
import com.firefly.example.kotlin.coffee.store.vo.InventoryOperator;
import com.firefly.example.kotlin.coffee.store.vo.InventoryUpdate;
import com.firefly.example.kotlin.coffee.store.vo.OrderStatus;
import com.firefly.example.kotlin.coffee.store.vo.ProductBuyRequest;
import com.firefly.utils.CollectionUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0012J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0012J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0012J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0012R\u0012\u0010\u0003\u001a\u00020\u00048\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcom/firefly/example/kotlin/coffee/store/service/impl/OrderServiceImpl;", "Lcom/firefly/example/kotlin/coffee/store/service/OrderService;", "()V", "inventoryDAO", "Lcom/firefly/example/kotlin/coffee/store/dao/InventoryDAO;", "orderDAO", "Lcom/firefly/example/kotlin/coffee/store/dao/OrderDAO;", "productDAO", "Lcom/firefly/example/kotlin/coffee/store/dao/ProductDAO;", "buy", "", "request", "Lcom/firefly/example/kotlin/coffee/store/vo/ProductBuyRequest;", "(Lcom/firefly/example/kotlin/coffee/store/vo/ProductBuyRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAmount", "", "product", "Lcom/firefly/example/kotlin/coffee/store/model/Product;", "toOrders", "", "Lcom/firefly/example/kotlin/coffee/store/model/Order;", "products", "toProductIdList", "verifyInventory", "arr", "", "firefly-example"})
public class OrderServiceImpl
implements OrderService {
    @Inject
    private OrderDAO orderDAO;
    @Inject
    private InventoryDAO inventoryDAO;
    @Inject
    private ProductDAO productDAO;

    @Override
    @Nullable
    public Object buy(@NotNull ProductBuyRequest productBuyRequest, @NotNull Continuation<? super Unit> continuation) {
        return OrderServiceImpl.buy$suspendImpl(this, productBuyRequest, continuation);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object buy$suspendImpl(OrderServiceImpl this, ProductBuyRequest request, Continuation var2_2) {
        if (!(var2_2 instanceof buy.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ OrderServiceImpl this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;

                @Nullable
                public final Object invokeSuspend(@NotNull Object result) {
                    this.result = result;
                    this.label |= Integer.MIN_VALUE;
                    return OrderServiceImpl.buy$suspendImpl(this.this$0, null, (Continuation)this);
                }
                {
                    this.this$0 = orderServiceImpl;
                    super(continuation);
                }
            };
        }
        var7_4 = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                v0 = var7_4;
                if (v0 instanceof Result.Failure) {
                    throw ((Result.Failure)v0).exception;
                }
                if (Objects.equals(request.getUserId(), Boxing.boxLong((long)0L))) {
                    throw (Throwable)new IllegalArgumentException("The user id is required");
                }
                if (CollectionUtils.isEmpty((Collection)request.getProducts())) {
                    throw (Throwable)new IllegalArgumentException("The products must bu not empty");
                }
                var5_6 = this;
                v1 = this.inventoryDAO;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"inventoryDAO");
                }
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.L$2 = var5_6;
                $continuation.label = 1;
                v2 = v1.updateBatch(request.getProducts(), InventoryOperator.SUB, (Continuation<? super int[]>)$continuation);
                if (v2 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl38
            }
            case 1: {
                var5_6 = (OrderServiceImpl)$continuation.L$2;
                request = (ProductBuyRequest)$continuation.L$1;
                this = (OrderServiceImpl)$continuation.L$0;
                v3 = var7_4;
                if (v3 instanceof Result.Failure) {
                    throw ((Result.Failure)v3).exception;
                }
                v2 = var7_4;
lbl38:
                // 2 sources

                var6_7 = v2;
                var5_6.verifyInventory((int[])var6_7);
                v4 = this.productDAO;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"productDAO");
                }
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.label = 2;
                v5 = v4.list(this.toProductIdList(request), (Continuation<? super List<? extends Product>>)$continuation);
                if (v5 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl57
            }
            case 2: {
                request = (ProductBuyRequest)$continuation.L$1;
                this = (OrderServiceImpl)$continuation.L$0;
                v6 = var7_4;
                if (v6 instanceof Result.Failure) {
                    throw ((Result.Failure)v6).exception;
                }
                v5 = var7_4;
lbl57:
                // 2 sources

                products = (List)v5;
                orders = this.toOrders(request, products);
                v7 = this.orderDAO;
                if (v7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"orderDAO");
                }
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.L$2 = products;
                $continuation.L$3 = orders;
                $continuation.label = 3;
                v8 = v7.insertBatch(orders, (Continuation<? super List<Long>>)$continuation);
                if (v8 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl80
            }
            case 3: {
                orders = (List)$continuation.L$3;
                products = (List)$continuation.L$2;
                request = (ProductBuyRequest)$continuation.L$1;
                this = (OrderServiceImpl)$continuation.L$0;
                v9 = var7_4;
                if (v9 instanceof Result.Failure) {
                    throw ((Result.Failure)v9).exception;
                }
                v8 = var7_4;
lbl80:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private void verifyInventory(int[] arr) {
        if (Arrays.stream(arr).anyMatch(verifyInventory.1.INSTANCE)) {
            throw (Throwable)new IllegalStateException("The products are not enough");
        }
    }

    private List<Long> toProductIdList(ProductBuyRequest request) {
        List<Long> list2 = request.getProducts().parallelStream().map(toProductIdList.1.INSTANCE).collect(Collectors.toList());
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"request.products.paralle\u2026ollectors.toList<Long>())");
        return list2;
    }

    private List<Order> toOrders(ProductBuyRequest request, List<? extends Product> products) {
        List<Order> list2 = products.parallelStream().map(new Function<T, R>(this, request){
            final /* synthetic */ OrderServiceImpl this$0;
            final /* synthetic */ ProductBuyRequest $request;

            @NotNull
            public final Order apply(Product product) {
                Product product2 = product;
                Intrinsics.checkExpressionValueIsNotNull((Object)product2, (String)"product");
                long amount = OrderServiceImpl.access$getAmount(this.this$0, this.$request, product2);
                double totalPrice = BigDecimal.valueOf(product.getPrice()).multiply(BigDecimal.valueOf(amount)).doubleValue();
                Long l = product.getId();
                Long l2 = this.$request.getUserId();
                return new Order(null, OrderStatus.FINISHED.getValue(), amount, product.getPrice(), totalPrice, l != null ? l : 0L, l2 != null ? l2 : 0L, product.getDescription(), null, null);
            }
            {
                this.this$0 = orderServiceImpl;
                this.$request = productBuyRequest;
            }
        }).collect(Collectors.toList());
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"products.parallelStream(\u2026llectors.toList<Order>())");
        return list2;
    }

    private long getAmount(ProductBuyRequest request, Product product) {
        Object r = request.getProducts().parallelStream().filter((Predicate)new Predicate<InventoryUpdate>(product){
            final /* synthetic */ Product $product;

            public final boolean test(InventoryUpdate i) {
                return Objects.equals(i.getProductId(), this.$product.getId());
            }
            {
                this.$product = product;
            }
        }).map(getAmount.2.INSTANCE).findFirst().orElseThrow(getAmount.3.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(r, (String)"request.products.paralle\u2026s must be more than 0\") }");
        return ((Number)r).longValue();
    }

    public static final /* synthetic */ long access$getAmount(OrderServiceImpl $this, @NotNull ProductBuyRequest request, @NotNull Product product) {
        return $this.getAmount(request, product);
    }
}

