/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.example.kotlin.coffee.store.utils;

import com.firefly.annotation.Component;
import com.firefly.annotation.Inject;
import com.firefly.db.init.ScriptUtils;
import com.firefly.example.kotlin.coffee.store.utils.DBUtils;
import com.firefly.example.kotlin.coffee.store.utils.DBUtilsKt;
import com.firefly.example.kotlin.coffee.store.utils.ResourceUtils;
import com.firefly.utils.io.Resource;
import java.sql.Connection;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u000e8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/firefly/example/kotlin/coffee/store/utils/DBUtils;", "", "()V", "dataSource", "Ljavax/sql/DataSource;", "getDataSource", "()Ljavax/sql/DataSource;", "setDataSource", "(Ljavax/sql/DataSource;)V", "initDataScript", "Lcom/firefly/utils/io/Resource;", "getInitDataScript", "()Lcom/firefly/utils/io/Resource;", "resourceUtils", "Lcom/firefly/example/kotlin/coffee/store/utils/ResourceUtils;", "getResourceUtils", "()Lcom/firefly/example/kotlin/coffee/store/utils/ResourceUtils;", "setResourceUtils", "(Lcom/firefly/example/kotlin/coffee/store/utils/ResourceUtils;)V", "schemaScript", "getSchemaScript", "createTables", "", "executeScript", "resource", "initializeData", "Companion", "firefly-example"})
public class DBUtils {
    @Inject
    @NotNull
    public DataSource dataSource;
    @Inject
    @NotNull
    public ResourceUtils resourceUtils;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public DataSource getDataSource() {
        DataSource dataSource = this.dataSource;
        if (dataSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dataSource");
        }
        return dataSource;
    }

    public void setDataSource(@NotNull DataSource dataSource) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"<set-?>");
        this.dataSource = dataSource;
    }

    @NotNull
    public ResourceUtils getResourceUtils() {
        ResourceUtils resourceUtils = this.resourceUtils;
        if (resourceUtils == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resourceUtils");
        }
        return resourceUtils;
    }

    public void setResourceUtils(@NotNull ResourceUtils resourceUtils) {
        Intrinsics.checkParameterIsNotNull((Object)resourceUtils, (String)"<set-?>");
        this.resourceUtils = resourceUtils;
    }

    @NotNull
    public Resource getSchemaScript() {
        return this.getResourceUtils().resource("/dbScript/coffee_store_schema.sql");
    }

    @NotNull
    public Resource getInitDataScript() {
        return this.getResourceUtils().resource("/dbScript/coffee_store_init_data.sql");
    }

    public void createTables() {
        this.executeScript(this.getSchemaScript());
    }

    public void initializeData() {
        this.executeScript(this.getInitDataScript());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeScript(@NotNull Resource resource) {
        block9: {
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            try {
                AutoCloseable autoCloseable = this.getDataSource().getConnection();
                Throwable throwable = null;
                try {
                    Connection it = (Connection)autoCloseable;
                    ScriptUtils.executeSqlScript((Connection)it, (Resource)resource);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                String string;
                Logger $receiver$iv = DBUtilsKt.access$getLogger$p();
                if (!$receiver$iv.isErrorEnabled()) break block9;
                Logger logger2 = $receiver$iv;
                try {
                    string = String.valueOf("execute SQL exception");
                }
                catch (Exception e$iv$iv) {
                    string = "KtLogger: get message exception: " + e$iv$iv;
                }
                String string2 = string;
                logger2.error(string2, (Throwable)e);
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a8\u0006\u0007"}, d2={"Lcom/firefly/example/kotlin/coffee/store/utils/DBUtils$Companion;", "", "()V", "toWildcard", "", "list", "", "firefly-example"})
    public static final class Companion {
        @NotNull
        public final String toWildcard(@NotNull List<?> list2) {
            Intrinsics.checkParameterIsNotNull(list2, (String)"list");
            String string = list2.parallelStream().map(toWildcard.1.INSTANCE).collect(Collectors.joining(","));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"list.parallelStream().ma\u2026(Collectors.joining(\",\"))");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

