/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.example.reactive.coffee.store;

import com.firefly.$;
import com.firefly.annotation.Inject;
import com.firefly.core.ApplicationContext;
import com.firefly.example.reactive.coffee.store.ProjectConfig;
import com.firefly.example.reactive.coffee.store.router.RouterInstaller;
import com.firefly.example.reactive.coffee.store.utils.DBUtils;
import com.firefly.server.http2.HTTP2ServerBuilder;
import com.firefly.utils.lang.AbstractLifeCycle;
import com.firefly.utils.log.slf4j.ext.LazyLogger;

public class AppMain
extends AbstractLifeCycle {
    private static final LazyLogger logger = LazyLogger.create();
    public static final ApplicationContext javaCtx = $.createApplicationContext((String)"java-example.xml");
    @Inject
    private HTTP2ServerBuilder server;
    @Inject
    private ProjectConfig config;
    @Inject
    private DBUtils dbUtils;

    public void initData() {
        this.dbUtils.createTables();
        this.dbUtils.initializeData();
    }

    public void installRouters() {
        javaCtx.getBeans(RouterInstaller.class).stream().sorted().forEach(installer -> {
            logger.info(() -> "install routers [" + installer.getClass().getName() + "]");
            installer.install();
        });
    }

    protected void init() {
        this.initData();
        this.installRouters();
        this.server.listen(this.config.getHost(), this.config.getPort());
    }

    protected void destroy() {
        this.server.stop();
    }

    public static void main(String[] args) {
        ((AppMain)((Object)javaCtx.getBean(AppMain.class))).start();
    }
}

