/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.example.reactive.coffee.store.router.impl.biz;

import com.firefly.annotation.Component;
import com.firefly.annotation.Inject;
import com.firefly.example.reactive.coffee.store.ProjectConfig;
import com.firefly.example.reactive.coffee.store.service.OrderService;
import com.firefly.example.reactive.coffee.store.vo.ProductBuyRequest;
import com.firefly.example.reactive.coffee.store.vo.Response;
import com.firefly.example.reactive.coffee.store.vo.ResponseStatus;
import com.firefly.example.reactive.coffee.store.vo.UserInfo;
import com.firefly.server.http2.router.Handler;
import com.firefly.server.http2.router.RoutingContext;

@Component(value="orderHandler")
public class OrderHandler
implements Handler {
    @Inject
    private ProjectConfig config;
    @Inject
    private OrderService orderService;

    public void handle(RoutingContext ctx) {
        UserInfo userInfo = (UserInfo)ctx.getAttribute(this.config.getLoginUserKey());
        if (userInfo == null) {
            ctx.fail((Throwable)new IllegalStateException("The user does not login"));
            return;
        }
        ProductBuyRequest request = (ProductBuyRequest)ctx.getJsonBody(ProductBuyRequest.class);
        if (request == null) {
            ctx.fail((Throwable)new IllegalArgumentException("Buy request must be not null"));
            return;
        }
        request.setUserId(userInfo.getId());
        this.orderService.buy(request).subscribe(ret -> {
            Response<Boolean> response = new Response<Boolean>();
            response.setStatus(ResponseStatus.OK.getValue());
            response.setData((Boolean)ret);
            response.setMessage(ResponseStatus.OK.getDescription());
            ctx.writeJson(response).end().succeed(ret);
        }, arg_0 -> ((RoutingContext)ctx).fail(arg_0));
    }
}

