/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.example.reactive.coffee.store.router.impl.sys;

import com.firefly.$;
import com.firefly.annotation.Component;
import com.firefly.example.reactive.coffee.store.vo.Response;
import com.firefly.example.reactive.coffee.store.vo.ResponseStatus;
import com.firefly.server.http2.router.Handler;
import com.firefly.server.http2.router.RoutingContext;
import com.firefly.utils.log.slf4j.ext.LazyLogger;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Mono;

@Component(value="globalHandler")
public class GlobalHandler
implements Handler {
    private static final LazyLogger logger = LazyLogger.create();

    public void handle(RoutingContext ctx) {
        ctx.getResponse().setAsynchronous(true);
        Mono.fromFuture((CompletableFuture)ctx.nextFuture()).timeout(Duration.ofSeconds(1L)).subscribe(ret -> ctx.end(), ex -> {
            if (ex instanceof IllegalArgumentException) {
                this.renderIllegalArgumentException(ctx, (IllegalArgumentException)ex);
            } else if (ex.getCause() instanceof IllegalArgumentException) {
                this.renderIllegalArgumentException(ctx, (IllegalArgumentException)ex.getCause());
            } else if (ex instanceof IllegalStateException) {
                this.renderIllegalStateException(ctx, (IllegalStateException)ex);
            } else if (ex.getCause() instanceof IllegalStateException) {
                this.renderIllegalStateException(ctx, (IllegalStateException)ex.getCause());
            } else {
                ctx.setStatus(500);
                logger.error(() -> "Server exception. " + ctx.getURI(), ex);
                Response response = new Response();
                response.setStatus(ResponseStatus.SERVER_ERROR.getValue());
                response.setMessage("server exception, " + ex.getMessage());
                ctx.writeJson(response).end();
            }
        });
    }

    private void renderIllegalArgumentException(RoutingContext ctx, IllegalArgumentException ex) {
        ctx.setStatus(200);
        logger.info(() -> $.string.replace((String)"Request error. [{}], [{}]", (Object[])new Object[]{ctx.getURI(), ex.getMessage()}));
        Response response = new Response();
        response.setStatus(ResponseStatus.ARGUMENT_ERROR.getValue());
        response.setMessage(ex.getMessage());
        ctx.writeJson(response).end();
    }

    private void renderIllegalStateException(RoutingContext ctx, IllegalStateException ex) {
        ctx.setStatus(200);
        logger.info(() -> $.string.replace((String)"Request error. [{}], [{}]", (Object[])new Object[]{ctx.getURI(), ex.getMessage()}));
        Response response = new Response();
        response.setStatus(ResponseStatus.SERVER_ERROR.getValue());
        response.setMessage(ex.getMessage());
        ctx.writeJson(response).end();
    }
}

