/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.example.reactive.coffee.store.router.impl.sys;

import com.firefly.$;
import com.firefly.annotation.Component;
import com.firefly.annotation.Inject;
import com.firefly.codec.http2.encode.UrlEncoded;
import com.firefly.codec.http2.model.HttpMethod;
import com.firefly.db.RecordNotFound;
import com.firefly.example.reactive.coffee.store.ProjectConfig;
import com.firefly.example.reactive.coffee.store.router.impl.sys.ErrorRenderer;
import com.firefly.example.reactive.coffee.store.service.UserService;
import com.firefly.example.reactive.coffee.store.vo.UserInfo;
import com.firefly.server.http2.router.HTTPSession;
import com.firefly.server.http2.router.Handler;
import com.firefly.server.http2.router.RoutingContext;
import com.firefly.utils.log.slf4j.ext.LazyLogger;
import com.firefly.utils.pattern.Pattern;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.core.publisher.Mono;

@Component(value="loginHandler")
public class LoginHandler
implements Handler {
    private static final LazyLogger logger = LazyLogger.create();
    private List<Pattern> uriWhitelist = Stream.of("/", "/hello", "/favicon.ico", "/static/*", "/products").map(p -> Pattern.compile((String)p, (String)"*")).collect(Collectors.toList());
    @Inject
    private ProjectConfig config;
    @Inject
    private ErrorRenderer errorRenderer;
    @Inject
    private UserService userService;

    public void handle(RoutingContext ctx) {
        Mono.fromFuture((CompletableFuture)ctx.getSession()).subscribe(session -> {
            try {
                String path = ctx.getURI().getPath();
                if (path.equals(this.config.getLoginURL())) {
                    switch (HttpMethod.fromString((String)ctx.getMethod())) {
                        case GET: {
                            this.renderLoginPage(ctx);
                            break;
                        }
                        case POST: {
                            this.verifyPasswordRequest(ctx, (HTTPSession)session);
                            break;
                        }
                        default: {
                            this.errorRenderer.renderError(ctx, 405);
                            break;
                        }
                    }
                } else if (path.equals(this.config.getLogoutURL())) {
                    this.logout(ctx, (HTTPSession)session);
                } else {
                    this.verifyLogin(ctx, (HTTPSession)session);
                }
            }
            catch (Exception e) {
                ctx.fail((Throwable)e);
            }
        }, arg_0 -> ((RoutingContext)ctx).fail(arg_0));
    }

    private void logout(RoutingContext ctx, HTTPSession session) {
        String backURL = ctx.getParamOpt("backURL").filter($.string::hasText).orElse("/");
        Mono.fromFuture((CompletableFuture)ctx.removeSession()).subscribe(ret -> {
            ctx.removeAttribute(this.config.getLoginUserKey());
            ctx.redirect(backURL);
            ctx.succeed((Object)true);
            logger.info(() -> "logout success!");
        }, arg_0 -> ((RoutingContext)ctx).fail(arg_0));
    }

    private void renderLoginPage(RoutingContext ctx) {
        String backURL = ctx.getParameter("backURL");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("backURL", backURL);
        ctx.renderTemplate(this.config.getTemplateRoot() + "/login.mustache", map);
        ctx.succeed((Object)true);
    }

    private void verifyPasswordRequest(RoutingContext ctx, HTTPSession session) {
        String username = ctx.getParameter("username");
        String password = ctx.getParameter("password");
        if (!$.string.hasText((String)username)) {
            ctx.fail((Throwable)new IllegalArgumentException("The username is required"));
            return;
        }
        if (!$.string.hasText((String)password)) {
            ctx.fail((Throwable)new IllegalArgumentException("The password is required"));
            return;
        }
        this.userService.getByName(username).subscribe(user -> {
            if (!user.getPassword().equals(password)) {
                ctx.fail((Throwable)new IllegalArgumentException("The password is incorrect"));
            } else {
                String backURL = ctx.getParamOpt("backURL").filter($.string::hasText).orElse("/");
                UserInfo userInfo = new UserInfo();
                $.javabean.copyBean((Object)user, (Object)userInfo);
                session.getAttributes().put(this.config.getLoginUserKey(), userInfo);
                session.setMaxInactiveInterval(this.config.getSessionMaxInactiveInterval());
                Mono.fromFuture((CompletableFuture)ctx.updateSession(session)).subscribe(ret -> {
                    ctx.setAttribute(this.config.getLoginUserKey(), (Object)userInfo);
                    ctx.redirect(backURL);
                    ctx.succeed((Object)true);
                    logger.info(() -> "user " + userInfo + " login success!");
                }, arg_0 -> ((RoutingContext)ctx).fail(arg_0));
            }
        }, ex -> {
            if (ex.getCause() instanceof RecordNotFound) {
                ctx.fail((Throwable)new IllegalArgumentException("The username is incorrect"));
            } else {
                ctx.fail(ex);
            }
        });
    }

    private void verifyLogin(RoutingContext ctx, HTTPSession session) {
        UserInfo userInfo = (UserInfo)session.getAttributes().get(this.config.getLoginUserKey());
        if (this.skipVerify(ctx.getURI().getPath())) {
            Optional.ofNullable(userInfo).ifPresent(u -> ctx.setAttribute(this.config.getLoginUserKey(), u));
            ctx.next();
            return;
        }
        if (userInfo != null) {
            ctx.setAttribute(this.config.getLoginUserKey(), (Object)userInfo);
            ctx.next();
        } else {
            UrlEncoded urlEncoded = new UrlEncoded();
            urlEncoded.put("backURL", (Object)ctx.getURI().getPathQuery());
            String param = urlEncoded.encode(StandardCharsets.UTF_8, true);
            ctx.redirect(this.config.getLoginURL() + "?" + param);
            ctx.succeed((Object)true);
        }
    }

    private boolean skipVerify(String uri) {
        return this.uriWhitelist.parallelStream().anyMatch(p -> p.match(uri) != null);
    }
}

