/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.example.reactive.coffee.store.utils;

import com.firefly.annotation.Component;
import com.firefly.annotation.Inject;
import com.firefly.db.init.ScriptUtils;
import com.firefly.example.reactive.coffee.store.utils.ResourceUtils;
import com.firefly.utils.io.Resource;
import com.firefly.utils.log.slf4j.ext.LazyLogger;
import java.sql.Connection;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;

@Component
public class DBUtils {
    private static LazyLogger logger = LazyLogger.create();
    @Inject
    private DataSource dataSource;
    @Inject
    private ResourceUtils resourceUtils;

    public void createTables() {
        this.executeScript(this.getSchemaScript());
    }

    public void initializeData() {
        this.executeScript(this.getInitDataScript());
    }

    public void executeScript(Resource resource) {
        try (Connection connection = this.dataSource.getConnection();){
            ScriptUtils.executeSqlScript((Connection)connection, (Resource)resource);
        }
        catch (Exception e) {
            logger.error(() -> "execute SQL exception", (Throwable)e);
        }
    }

    public Resource getSchemaScript() {
        return this.resourceUtils.resource("/dbScript/coffee_store_schema.sql");
    }

    public Resource getInitDataScript() {
        return this.resourceUtils.resource("/dbScript/coffee_store_init_data.sql");
    }

    public static String toWildcard(List<?> list2) {
        return list2.parallelStream().map(o -> "?").collect(Collectors.joining(","));
    }
}

