/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.example.reactive.coffee.store.vo;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum OrderStatus {
    UNPAID(1, "unpaid"),
    PURCHASED(2, "purchased"),
    SHIPPED(3, "shipped"),
    FINISHED(4, "finished"),
    CANCELED(5, "canceled"),
    REFUND(6, "refund");

    private final int value;
    private final String description;

    private OrderStatus(int value, String description) {
        this.value = value;
        this.description = description;
        Holder.map.put(value, this);
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static Optional<OrderStatus> from(int value) {
        return Optional.ofNullable(Holder.map.get(value));
    }

    static class Holder {
        static final Map<Integer, OrderStatus> map = new HashMap<Integer, OrderStatus>();

        Holder() {
        }
    }
}

