/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.example.reactive.coffee.store.vo;

import com.firefly.$;
import java.util.ArrayList;
import java.util.List;

public class Page<T> {
    private List<T> record = new ArrayList<T>();
    private int number;
    private int size;
    private int total;
    private int pageCount;
    private int lastNumber;
    private int nextNumber;
    private boolean showPaging;
    private boolean next;
    private boolean last;

    public Page() {
    }

    public Page(List<T> record, int number, int size) {
        this.record = record;
        this.size = Math.max(size, 0);
        this.number = Math.max(number, 1);
        this.pageWithoutCount();
    }

    public Page(List<T> record, int total, int number, int size) {
        this.record = record;
        this.total = total;
        this.size = Math.max(size, 0);
        this.number = Math.max(number, 1);
        this.page();
    }

    public static String getPageSQLWithoutCount(int number, int size) {
        long offset = Math.max(number - 1, 0) * size;
        int pageSize = size + 1;
        return " limit " + offset + ", " + pageSize;
    }

    public static String getPageSQL(int number, int size) {
        long offset = Math.max(number - 1, 0) * size;
        return " limit " + offset + ", " + size;
    }

    public void pageWithoutCount() {
        this.last = this.number > 1;
        this.next = this.record.size() > this.size;
        this.showPaging = this.last || this.next;
        this.lastNumber = Math.max(this.number - 1, 1);
        int n = this.nextNumber = this.next ? this.number + 1 : this.number;
        if (this.next) {
            this.record.remove(this.record.size() - 1);
        }
    }

    public void page() {
        this.pageCount = (this.total + this.size - 1) / this.size;
        this.last = this.number > 1;
        this.next = this.number < this.pageCount;
        this.showPaging = this.last || this.next;
        this.lastNumber = Math.max(this.number - 1, 1);
        this.nextNumber = Math.min(this.number + 1, this.pageCount);
    }

    public List<T> getRecord() {
        return this.record;
    }

    public void setRecord(List<T> record) {
        this.record = record;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public int getLastNumber() {
        return this.lastNumber;
    }

    public void setLastNumber(int lastNumber) {
        this.lastNumber = lastNumber;
    }

    public int getNextNumber() {
        return this.nextNumber;
    }

    public void setNextNumber(int nextNumber) {
        this.nextNumber = nextNumber;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = Math.max(number, 1);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = Math.max(size, 0);
    }

    public boolean isShowPaging() {
        return this.showPaging;
    }

    public void setShowPaging(boolean showPaging) {
        this.showPaging = showPaging;
    }

    public boolean isNext() {
        return this.next;
    }

    public void setNext(boolean next) {
        this.next = next;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public String toString() {
        return $.json.toJson((Object)this);
    }
}

