/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.example.tcp;

import com.firefly.$;
import com.firefly.net.tcp.SimpleTcpClient;
import com.firefly.net.tcp.SimpleTcpServer;
import com.firefly.net.tcp.TcpConfiguration;
import com.firefly.net.tcp.TcpServerConfiguration;
import com.firefly.net.tcp.codec.flex.decode.StringParser;
import com.firefly.utils.RandomUtils;
import com.firefly.utils.io.IO;
import java.io.Closeable;
import java.util.concurrent.Phaser;

public class HelloTcpServerAndClientWithOpenssl {
    public static void main(String[] args) {
        String host = "localhost";
        int port = (int)RandomUtils.random((long)1000L, (long)65534L);
        Phaser phaser = new Phaser(2);
        SimpleTcpServer server = HelloTcpServerAndClientWithOpenssl.createTcpServer(host, port);
        SimpleTcpClient client = HelloTcpServerAndClientWithOpenssl.createTcpClient();
        server.accept(connection -> {
            StringParser parser = new StringParser();
            parser.complete(msg -> {
                String str;
                switch (str = msg.trim()) {
                    case "quit": {
                        connection.write("bye!\r\n");
                        IO.close((Closeable)connection);
                        break;
                    }
                    default: {
                        connection.write("The server received " + str + "\r\n");
                    }
                }
            });
            connection.receive(arg_0 -> ((StringParser)parser).receive(arg_0));
        }).start();
        client.connect(host, port).thenAccept(connection -> {
            StringParser parser = new StringParser();
            parser.complete(msg -> {
                String str = msg.trim();
                System.out.println(str);
                if (str.equals("bye!")) {
                    phaser.arrive();
                }
            });
            connection.receive(arg_0 -> ((StringParser)parser).receive(arg_0));
            connection.write("hello world\r\n").write("quit\r\n");
        });
        phaser.arriveAndAwaitAdvance();
        client.stop();
        server.stop();
    }

    private static SimpleTcpServer createTcpServer(String host, int port) {
        TcpServerConfiguration serverConfig = new TcpServerConfiguration();
        serverConfig.setSecureConnectionEnabled(true);
        serverConfig.setHost(host);
        serverConfig.setPort(port);
        return $.createTCPServer((TcpServerConfiguration)serverConfig);
    }

    private static SimpleTcpClient createTcpClient() {
        TcpConfiguration clientConfig = new TcpConfiguration();
        clientConfig.setSecureConnectionEnabled(true);
        return $.createTCPClient((TcpConfiguration)clientConfig);
    }
}

