/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flagsmith.Flag;
import com.flagsmith.MapperFactory;
import com.flagsmith.Trait;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FlagsAndTraits
implements Serializable {
    private List<Flag> flags;
    private List<Trait> traits;

    @JsonIgnore
    public void parse(String data) throws IOException {
        ObjectMapper mapper = MapperFactory.getMappper();
        FlagsAndTraits prototype = (FlagsAndTraits)mapper.readValue(data, FlagsAndTraits.class);
        this.fromPrototype(prototype);
    }

    @JsonIgnore
    private void fromPrototype(FlagsAndTraits prototype) throws IOException {
        this.setFlags(prototype.getFlags());
        this.setTraits(prototype.getTraits());
    }

    @JsonIgnore
    public String toString() {
        ObjectMapper mapper = MapperFactory.getMappper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return super.toString();
        }
    }

    public List<Flag> getFlags() {
        return this.flags;
    }

    public List<Trait> getTraits() {
        return this.traits;
    }

    public void setFlags(List<Flag> flags) {
        this.flags = flags;
    }

    public void setTraits(List<Trait> traits) {
        this.traits = traits;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlagsAndTraits)) {
            return false;
        }
        FlagsAndTraits other = (FlagsAndTraits)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Flag> this$flags = this.getFlags();
        List<Flag> other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        List<Trait> this$traits = this.getTraits();
        List<Trait> other$traits = other.getTraits();
        return !(this$traits == null ? other$traits != null : !((Object)this$traits).equals(other$traits));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlagsAndTraits;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Flag> $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        List<Trait> $traits = this.getTraits();
        result = result * 59 + ($traits == null ? 43 : ((Object)$traits).hashCode());
        return result;
    }
}

