/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.flagsmith.FeatureUser;
import com.flagsmith.FlagsAndTraits;
import com.flagsmith.FlagsmithApiWrapper;
import com.flagsmith.FlagsmithCache;
import com.flagsmith.FlagsmithCacheConfig;
import com.flagsmith.FlagsmithConfig;
import com.flagsmith.FlagsmithSdk;
import com.flagsmith.Trait;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class FlagsmithCachedApiWrapper
implements FlagsmithSdk {
    private final FlagsmithApiWrapper flagsmithApiWrapper;
    private final FlagsmithCacheConfig.FlagsmithInternalCache cache;

    public FlagsmithCachedApiWrapper(FlagsmithCacheConfig.FlagsmithInternalCache cache, FlagsmithApiWrapper flagsmithApiWrapper) {
        this.cache = cache;
        this.flagsmithApiWrapper = flagsmithApiWrapper;
    }

    @Override
    public FlagsAndTraits getFeatureFlags(FeatureUser user, boolean doThrow) {
        String cacheKey = this.cache.getEnvFlagsCacheKey();
        if (user == null && StringUtils.isBlank((CharSequence)cacheKey)) {
            return this.flagsmithApiWrapper.getFeatureFlags(null, doThrow);
        }
        if (user != null) {
            this.assertValidUser(user);
            return (FlagsAndTraits)this.cache.getCache().get((Object)user.getIdentifier(), k -> this.flagsmithApiWrapper.getFeatureFlags(user, doThrow));
        }
        return (FlagsAndTraits)this.cache.getCache().get((Object)cacheKey, k -> this.flagsmithApiWrapper.getFeatureFlags(user, doThrow));
    }

    @Override
    public FlagsAndTraits getUserFlagsAndTraits(FeatureUser user, boolean doThrow) {
        this.assertValidUser(user);
        return (FlagsAndTraits)this.cache.getCache().get((Object)user.getIdentifier(), k -> this.flagsmithApiWrapper.getUserFlagsAndTraits(user, doThrow));
    }

    @Override
    public Trait postUserTraits(FeatureUser user, Trait toUpdate, boolean doThrow) {
        this.assertValidUser(user);
        FlagsAndTraits flagsAndTraits = this.getCachedFlagsIfTraitsMatch(user, Arrays.asList(toUpdate));
        if (flagsAndTraits != null) {
            this.flagsmithApiWrapper.getLogger().info("User trait unchanged for user {}, trait: {}", user.getIdentifier(), toUpdate);
            return toUpdate;
        }
        return this.flagsmithApiWrapper.postUserTraits(user, toUpdate, doThrow);
    }

    @Override
    public FlagsAndTraits identifyUserWithTraits(FeatureUser user, List<Trait> traits, boolean doThrow) {
        this.assertValidUser(user);
        FlagsAndTraits flagsAndTraits = this.getCachedFlagsIfTraitsMatch(user, traits);
        if (flagsAndTraits != null) {
            return flagsAndTraits;
        }
        flagsAndTraits = this.flagsmithApiWrapper.identifyUserWithTraits(user, traits, doThrow);
        this.cache.getCache().put((Object)user.getIdentifier(), (Object)flagsAndTraits);
        return flagsAndTraits;
    }

    @Override
    public FlagsmithConfig getConfig() {
        return this.flagsmithApiWrapper.getConfig();
    }

    @Override
    public FlagsmithCache getCache() {
        return this.cache;
    }

    private FlagsAndTraits getCachedFlagsIfTraitsMatch(FeatureUser user, List<Trait> traitsToMatch) {
        FlagsAndTraits flagsAndTraits = (FlagsAndTraits)this.cache.getCache().getIfPresent((Object)user.getIdentifier());
        if (flagsAndTraits == null) {
            return null;
        }
        if (flagsAndTraits.getTraits() != null) {
            boolean allTraitsFound;
            boolean bl = allTraitsFound = traitsToMatch == null || traitsToMatch.isEmpty() || traitsToMatch.stream().allMatch(t -> {
                Trait newTrait = new Trait(null, t.getKey(), t.getValue());
                return flagsAndTraits.getTraits().contains(newTrait);
            });
            if (allTraitsFound) {
                return flagsAndTraits;
            }
        }
        this.cache.getCache().invalidate((Object)user.getIdentifier());
        return null;
    }
}

