/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flagsmith.FlagsmithLogger;
import com.flagsmith.MapperFactory;
import com.flagsmith.config.FlagsmithConfig;
import com.flagsmith.flagengine.environments.EnvironmentModel;
import com.flagsmith.flagengine.features.FeatureStateModel;
import com.flagsmith.flagengine.identities.traits.TraitModel;
import com.flagsmith.interfaces.FlagsmithCache;
import com.flagsmith.interfaces.FlagsmithSdk;
import com.flagsmith.models.Flags;
import com.flagsmith.threads.RequestProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class FlagsmithApiWrapper
implements FlagsmithSdk {
    private static final String AUTH_HEADER = "X-Environment-Key";
    private static final String ACCEPT_HEADER = "Accept";
    private static final Integer TIMEOUT = 15000;
    private final FlagsmithLogger logger;
    private final FlagsmithConfig defaultConfig;
    private final HashMap<String, String> customHeaders;
    private final String apiKey;
    private RequestProcessor requestor;
    private FlagsmithCache cache = null;

    public FlagsmithApiWrapper(FlagsmithCache cache, FlagsmithConfig defaultConfig, HashMap<String, String> customHeaders, FlagsmithLogger logger, String apiKey) {
        this(defaultConfig, customHeaders, logger, apiKey);
        this.cache = cache;
    }

    public FlagsmithApiWrapper(FlagsmithConfig defaultConfig, HashMap<String, String> customHeaders, FlagsmithLogger logger, String apiKey) {
        this.defaultConfig = defaultConfig;
        this.customHeaders = customHeaders;
        this.logger = logger;
        this.apiKey = apiKey;
        this.requestor = new RequestProcessor(defaultConfig.getHttpClient(), logger, defaultConfig.getRetries());
    }

    @Override
    public Flags getFeatureFlags(boolean doThrow) {
        Flags featureFlags;
        block7: {
            featureFlags = new Flags();
            if (this.getCache() != null && (featureFlags = this.getCache().getIfPresent(this.getCache().getEnvFlagsCacheKey())) != null) {
                return featureFlags;
            }
            HttpUrl urlBuilder = this.defaultConfig.getFlagsUri();
            Request request = this.newGetRequest(urlBuilder);
            Future<List<FeatureStateModel>> featureFlagsFuture = this.requestor.executeAsync(request, new TypeReference<List<FeatureStateModel>>(){}, doThrow);
            try {
                List<FeatureStateModel> featureFlagsResponse = featureFlagsFuture.get(TIMEOUT.intValue(), TimeUnit.MILLISECONDS);
                if (featureFlagsResponse == null) {
                    featureFlagsResponse = new ArrayList<FeatureStateModel>();
                }
                featureFlags = Flags.fromApiFlags(featureFlagsResponse, this.getConfig().getAnalyticsProcessor(), this.getConfig().getFlagsmithFlagDefaults());
                if (this.getCache() != null) {
                    this.getCache().getCache().put((Object)this.getCache().getEnvFlagsCacheKey(), (Object)featureFlags);
                    this.logger.info("Got feature flags for flags = {} and cached.", featureFlags);
                }
            }
            catch (TimeoutException te) {
                this.logger.error("Timed out on fetching Feature flags.", te);
            }
            catch (InterruptedException ie) {
                this.logger.error("Interrupted on fetching Feature flags.", ie);
            }
            catch (ExecutionException ee) {
                this.logger.error("Execution failed on fetching Feature flags.", ee);
                if (!doThrow) break block7;
                throw new RuntimeException(ee);
            }
        }
        this.logger.info("Got feature flags for flags = {}", featureFlags);
        return featureFlags;
    }

    @Override
    public Flags identifyUserWithTraits(String identifier, List<TraitModel> traits, boolean doThrow) {
        Flags flagsAndTraits;
        block7: {
            this.assertValidUser(identifier);
            flagsAndTraits = null;
            if (this.getCache() != null && (flagsAndTraits = this.getCache().getIfPresent(this.getCache().getEnvFlagsCacheKey())) != null) {
                return flagsAndTraits;
            }
            HttpUrl url = this.defaultConfig.getIdentitiesUri();
            ObjectNode node = MapperFactory.getMapper().createObjectNode();
            node.put("identifier", identifier);
            if (traits != null) {
                node.putPOJO("traits", traits);
            }
            MediaType json = MediaType.parse((String)"application/json; charset=utf-8");
            RequestBody body = RequestBody.create((MediaType)json, (String)node.toString());
            Request request = this.newPostRequest(url, body);
            Future<JsonNode> featureFlagsFuture = this.requestor.executeAsync(request, doThrow);
            try {
                JsonNode flagsAndTraitsResponse = featureFlagsFuture.get(TIMEOUT.intValue(), TimeUnit.MILLISECONDS);
                ArrayNode flagsArray = flagsAndTraitsResponse != null && flagsAndTraitsResponse.has("flags") ? flagsAndTraitsResponse.get("flags") : MapperFactory.getMapper().createArrayNode();
                flagsAndTraits = Flags.fromApiFlags((JsonNode)flagsArray, this.getConfig().getAnalyticsProcessor(), this.getConfig().getFlagsmithFlagDefaults());
                if (this.getCache() != null) {
                    this.getCache().getCache().put((Object)("identifier" + identifier), (Object)flagsAndTraits);
                    this.logger.info("Got feature flags for flags = {} and cached.", flagsAndTraits);
                }
            }
            catch (TimeoutException ie) {
                this.logger.error("Timed out on fetching Feature flags.", ie);
            }
            catch (InterruptedException ie) {
                this.logger.error("Interrupted on fetching Feature flags.", ie);
            }
            catch (ExecutionException ee) {
                this.logger.error("Execution failed on fetching Feature flags.", ee);
                if (!doThrow) break block7;
                throw new RuntimeException(ee);
            }
        }
        this.logger.info("Got flags based on identify for identifier = {}, flags = {}", identifier, flagsAndTraits);
        return flagsAndTraits;
    }

    @Override
    public EnvironmentModel getEnvironment() {
        Request request = this.newGetRequest(this.defaultConfig.getEnvironmentUri());
        Future<EnvironmentModel> environmentFuture = this.requestor.executeAsync(request, new TypeReference<EnvironmentModel>(){}, Boolean.TRUE);
        try {
            return environmentFuture.get(TIMEOUT.intValue(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ie) {
            this.logger.error("Timed out on fetching Feature flags.", ie);
        }
        catch (InterruptedException ie) {
            this.logger.error("Environment loading interrupted.", ie);
        }
        catch (ExecutionException ee) {
            this.logger.error("Execution failed on Environment loading.", ee);
            throw new RuntimeException(ee);
        }
        return null;
    }

    @Override
    public FlagsmithConfig getConfig() {
        return this.defaultConfig;
    }

    @Override
    public FlagsmithCache getCache() {
        return this.cache;
    }

    public FlagsmithLogger getLogger() {
        return this.logger;
    }

    private Request.Builder newRequestBuilder() {
        Request.Builder builder = new Request.Builder().header(AUTH_HEADER, this.apiKey).addHeader(ACCEPT_HEADER, "application/json");
        if (this.customHeaders != null && !this.customHeaders.isEmpty()) {
            this.customHeaders.forEach((k, v) -> builder.addHeader(k, v));
        }
        return builder;
    }

    @Override
    public Request newGetRequest(HttpUrl url) {
        Request.Builder builder = this.newRequestBuilder();
        builder.url(url);
        return builder.build();
    }

    @Override
    public Request newPostRequest(HttpUrl url, RequestBody body) {
        Request.Builder builder = this.newRequestBuilder();
        builder.url(url).post(body);
        return builder.build();
    }

    public FlagsmithConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public HashMap<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public RequestProcessor getRequestor() {
        return this.requestor;
    }

    public void setRequestor(RequestProcessor requestor) {
        this.requestor = requestor;
    }

    public void setCache(FlagsmithCache cache) {
        this.cache = cache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlagsmithApiWrapper)) {
            return false;
        }
        FlagsmithApiWrapper other = (FlagsmithApiWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FlagsmithLogger this$logger = this.getLogger();
        FlagsmithLogger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        FlagsmithConfig this$defaultConfig = this.getDefaultConfig();
        FlagsmithConfig other$defaultConfig = other.getDefaultConfig();
        if (this$defaultConfig == null ? other$defaultConfig != null : !((Object)this$defaultConfig).equals(other$defaultConfig)) {
            return false;
        }
        HashMap<String, String> this$customHeaders = this.getCustomHeaders();
        HashMap<String, String> other$customHeaders = other.getCustomHeaders();
        if (this$customHeaders == null ? other$customHeaders != null : !((Object)this$customHeaders).equals(other$customHeaders)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        RequestProcessor this$requestor = this.getRequestor();
        RequestProcessor other$requestor = other.getRequestor();
        if (this$requestor == null ? other$requestor != null : !((Object)this$requestor).equals(other$requestor)) {
            return false;
        }
        FlagsmithCache this$cache = this.getCache();
        FlagsmithCache other$cache = other.getCache();
        return !(this$cache == null ? other$cache != null : !this$cache.equals(other$cache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlagsmithApiWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FlagsmithLogger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        FlagsmithConfig $defaultConfig = this.getDefaultConfig();
        result = result * 59 + ($defaultConfig == null ? 43 : ((Object)$defaultConfig).hashCode());
        HashMap<String, String> $customHeaders = this.getCustomHeaders();
        result = result * 59 + ($customHeaders == null ? 43 : ((Object)$customHeaders).hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        RequestProcessor $requestor = this.getRequestor();
        result = result * 59 + ($requestor == null ? 43 : ((Object)$requestor).hashCode());
        FlagsmithCache $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        return result;
    }

    public String toString() {
        return "FlagsmithApiWrapper(logger=" + this.getLogger() + ", defaultConfig=" + this.getDefaultConfig() + ", customHeaders=" + this.getCustomHeaders() + ", apiKey=" + this.getApiKey() + ", requestor=" + this.getRequestor() + ", cache=" + this.getCache() + ")";
    }
}

