/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine.features;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.flagsmith.flagengine.features.FeatureModel;
import com.flagsmith.flagengine.features.FeatureSegmentModel;
import com.flagsmith.flagengine.features.MultivariateFeatureStateValueModel;
import com.flagsmith.flagengine.utils.Hashing;
import com.flagsmith.utils.models.BaseModel;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class FeatureStateModel
extends BaseModel {
    private FeatureModel feature;
    private Boolean enabled;
    @JsonProperty(value="django_id")
    private Integer djangoId;
    @JsonProperty(value="featurestate_uuid")
    private String featurestateUuid = UUID.randomUUID().toString();
    @JsonProperty(value="multivariate_feature_state_values")
    private List<MultivariateFeatureStateValueModel> multivariateFeatureStateValues;
    @JsonProperty(value="feature_state_value")
    private Object value;
    @JsonProperty(value="feature_segment")
    private FeatureSegmentModel featureSegment;

    public Object getValue(Object identityId) {
        if (identityId != null && this.multivariateFeatureStateValues != null && this.multivariateFeatureStateValues.size() > 0) {
            return this.getMultiVariateValue(identityId);
        }
        return this.value;
    }

    private Object getMultiVariateValue(Object identityId) {
        List<String> objectIds = Arrays.asList(this.djangoId != null && this.djangoId != 0 ? this.djangoId.toString() : this.featurestateUuid, identityId.toString());
        Float percentageValue = Hashing.getInstance().getHashedPercentageForObjectIds(objectIds);
        Float startPercentage = Float.valueOf(0.0f);
        List sortedMultiVariateFeatureStates = this.multivariateFeatureStateValues.stream().sorted((smvfs1, smvfs2) -> smvfs1.getSortValue().compareTo(smvfs2.getSortValue())).collect(Collectors.toList());
        for (MultivariateFeatureStateValueModel multiVariate : sortedMultiVariateFeatureStates) {
            Float limit = Float.valueOf(multiVariate.getPercentageAllocation().floatValue() + startPercentage.floatValue());
            if (startPercentage.floatValue() <= percentageValue.floatValue() && percentageValue.floatValue() < limit.floatValue()) {
                return multiVariate.getMultivariateFeatureOption().getValue();
            }
            startPercentage = limit;
        }
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FeatureStateModel)) {
            return false;
        }
        return this.getFeature().getId() == ((FeatureStateModel)o).getFeature().getId();
    }

    public boolean isHigherPriority(FeatureStateModel other) {
        if (this.featureSegment == null || other.featureSegment == null) {
            return this.featureSegment != null && other.featureSegment == null;
        }
        return this.featureSegment.getPriority() < other.featureSegment.getPriority();
    }

    public FeatureModel getFeature() {
        return this.feature;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Integer getDjangoId() {
        return this.djangoId;
    }

    public String getFeaturestateUuid() {
        return this.featurestateUuid;
    }

    public List<MultivariateFeatureStateValueModel> getMultivariateFeatureStateValues() {
        return this.multivariateFeatureStateValues;
    }

    public Object getValue() {
        return this.value;
    }

    public FeatureSegmentModel getFeatureSegment() {
        return this.featureSegment;
    }

    public void setFeature(FeatureModel feature) {
        this.feature = feature;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @JsonProperty(value="django_id")
    public void setDjangoId(Integer djangoId) {
        this.djangoId = djangoId;
    }

    @JsonProperty(value="featurestate_uuid")
    public void setFeaturestateUuid(String featurestateUuid) {
        this.featurestateUuid = featurestateUuid;
    }

    @JsonProperty(value="multivariate_feature_state_values")
    public void setMultivariateFeatureStateValues(List<MultivariateFeatureStateValueModel> multivariateFeatureStateValues) {
        this.multivariateFeatureStateValues = multivariateFeatureStateValues;
    }

    @JsonProperty(value="feature_state_value")
    public void setValue(Object value) {
        this.value = value;
    }

    @JsonProperty(value="feature_segment")
    public void setFeatureSegment(FeatureSegmentModel featureSegment) {
        this.featureSegment = featureSegment;
    }

    public String toString() {
        return "FeatureStateModel(feature=" + this.getFeature() + ", enabled=" + this.getEnabled() + ", djangoId=" + this.getDjangoId() + ", featurestateUuid=" + this.getFeaturestateUuid() + ", multivariateFeatureStateValues=" + this.getMultivariateFeatureStateValues() + ", value=" + this.getValue() + ", featureSegment=" + this.getFeatureSegment() + ")";
    }
}

