/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.config;

import com.flagsmith.FlagsmithFlagDefaults;
import com.flagsmith.config.Retry;
import com.flagsmith.threads.AnalyticsProcessor;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public final class FlagsmithConfig {
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 2000;
    private static final int DEFAULT_WRITE_TIMEOUT_MILLIS = 5000;
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = 5000;
    private static final int DEFAULT_ENVIRONMENT_REFRESH_SECONDS = 60;
    private static final HttpUrl DEFAULT_BASE_URI = HttpUrl.parse((String)"https://edge.api.flagsmith.com/api/v1/");
    private final HttpUrl flagsUri;
    private final HttpUrl identitiesUri;
    private final HttpUrl traitsUri;
    private final HttpUrl environmentUri;
    private final OkHttpClient httpClient;
    private final HttpUrl baseUri;
    private final Retry retries;
    private Boolean enableLocalEvaluation;
    private Integer environmentRefreshIntervalSeconds;
    private AnalyticsProcessor analyticsProcessor;
    private FlagsmithFlagDefaults flagsmithFlagDefaults = null;
    private Boolean raiseUpdateEnvironmentErrorsOnStartup = true;

    protected FlagsmithConfig(Builder builder) {
        this.baseUri = builder.baseUri;
        this.flagsUri = this.baseUri.newBuilder("flags/").build();
        this.identitiesUri = this.baseUri.newBuilder("identities/").build();
        this.traitsUri = this.baseUri.newBuilder("traits/").build();
        this.environmentUri = this.baseUri.newBuilder("environment-document/").build();
        OkHttpClient.Builder httpBuilder = new OkHttpClient.Builder().connectTimeout((long)builder.connectTimeoutMillis, TimeUnit.MILLISECONDS).writeTimeout((long)builder.writeTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout((long)builder.readTimeoutMillis, TimeUnit.MILLISECONDS);
        if (builder.sslSocketFactory != null && builder.trustManager != null) {
            httpBuilder = httpBuilder.sslSocketFactory(builder.sslSocketFactory, builder.trustManager);
        }
        for (Interceptor interceptor : builder.interceptors) {
            httpBuilder = httpBuilder.addInterceptor(interceptor);
        }
        if (builder.proxy != null) {
            httpBuilder = httpBuilder.proxy(builder.proxy);
        }
        this.httpClient = httpBuilder.build();
        this.retries = builder.retries;
        this.enableLocalEvaluation = builder.enableLocalEvaluation;
        this.environmentRefreshIntervalSeconds = builder.environmentRefreshIntervalSeconds;
        if (builder.enableAnalytics.booleanValue()) {
            this.analyticsProcessor = builder.analyticsProcessor != null ? builder.analyticsProcessor : new AnalyticsProcessor(this.httpClient);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public HttpUrl getFlagsUri() {
        return this.flagsUri;
    }

    public HttpUrl getIdentitiesUri() {
        return this.identitiesUri;
    }

    public HttpUrl getTraitsUri() {
        return this.traitsUri;
    }

    public HttpUrl getEnvironmentUri() {
        return this.environmentUri;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpUrl getBaseUri() {
        return this.baseUri;
    }

    public Retry getRetries() {
        return this.retries;
    }

    public Boolean getEnableLocalEvaluation() {
        return this.enableLocalEvaluation;
    }

    public Integer getEnvironmentRefreshIntervalSeconds() {
        return this.environmentRefreshIntervalSeconds;
    }

    public AnalyticsProcessor getAnalyticsProcessor() {
        return this.analyticsProcessor;
    }

    public FlagsmithFlagDefaults getFlagsmithFlagDefaults() {
        return this.flagsmithFlagDefaults;
    }

    public Boolean getRaiseUpdateEnvironmentErrorsOnStartup() {
        return this.raiseUpdateEnvironmentErrorsOnStartup;
    }

    public void setEnableLocalEvaluation(Boolean enableLocalEvaluation) {
        this.enableLocalEvaluation = enableLocalEvaluation;
    }

    public void setEnvironmentRefreshIntervalSeconds(Integer environmentRefreshIntervalSeconds) {
        this.environmentRefreshIntervalSeconds = environmentRefreshIntervalSeconds;
    }

    public void setAnalyticsProcessor(AnalyticsProcessor analyticsProcessor) {
        this.analyticsProcessor = analyticsProcessor;
    }

    public void setFlagsmithFlagDefaults(FlagsmithFlagDefaults flagsmithFlagDefaults) {
        this.flagsmithFlagDefaults = flagsmithFlagDefaults;
    }

    public void setRaiseUpdateEnvironmentErrorsOnStartup(Boolean raiseUpdateEnvironmentErrorsOnStartup) {
        this.raiseUpdateEnvironmentErrorsOnStartup = raiseUpdateEnvironmentErrorsOnStartup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlagsmithConfig)) {
            return false;
        }
        FlagsmithConfig other = (FlagsmithConfig)o;
        Boolean this$enableLocalEvaluation = this.getEnableLocalEvaluation();
        Boolean other$enableLocalEvaluation = other.getEnableLocalEvaluation();
        if (this$enableLocalEvaluation == null ? other$enableLocalEvaluation != null : !((Object)this$enableLocalEvaluation).equals(other$enableLocalEvaluation)) {
            return false;
        }
        Integer this$environmentRefreshIntervalSeconds = this.getEnvironmentRefreshIntervalSeconds();
        Integer other$environmentRefreshIntervalSeconds = other.getEnvironmentRefreshIntervalSeconds();
        if (this$environmentRefreshIntervalSeconds == null ? other$environmentRefreshIntervalSeconds != null : !((Object)this$environmentRefreshIntervalSeconds).equals(other$environmentRefreshIntervalSeconds)) {
            return false;
        }
        Boolean this$raiseUpdateEnvironmentErrorsOnStartup = this.getRaiseUpdateEnvironmentErrorsOnStartup();
        Boolean other$raiseUpdateEnvironmentErrorsOnStartup = other.getRaiseUpdateEnvironmentErrorsOnStartup();
        if (this$raiseUpdateEnvironmentErrorsOnStartup == null ? other$raiseUpdateEnvironmentErrorsOnStartup != null : !((Object)this$raiseUpdateEnvironmentErrorsOnStartup).equals(other$raiseUpdateEnvironmentErrorsOnStartup)) {
            return false;
        }
        HttpUrl this$flagsUri = this.getFlagsUri();
        HttpUrl other$flagsUri = other.getFlagsUri();
        if (this$flagsUri == null ? other$flagsUri != null : !this$flagsUri.equals(other$flagsUri)) {
            return false;
        }
        HttpUrl this$identitiesUri = this.getIdentitiesUri();
        HttpUrl other$identitiesUri = other.getIdentitiesUri();
        if (this$identitiesUri == null ? other$identitiesUri != null : !this$identitiesUri.equals(other$identitiesUri)) {
            return false;
        }
        HttpUrl this$traitsUri = this.getTraitsUri();
        HttpUrl other$traitsUri = other.getTraitsUri();
        if (this$traitsUri == null ? other$traitsUri != null : !this$traitsUri.equals(other$traitsUri)) {
            return false;
        }
        HttpUrl this$environmentUri = this.getEnvironmentUri();
        HttpUrl other$environmentUri = other.getEnvironmentUri();
        if (this$environmentUri == null ? other$environmentUri != null : !this$environmentUri.equals(other$environmentUri)) {
            return false;
        }
        OkHttpClient this$httpClient = this.getHttpClient();
        OkHttpClient other$httpClient = other.getHttpClient();
        if (this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient)) {
            return false;
        }
        HttpUrl this$baseUri = this.getBaseUri();
        HttpUrl other$baseUri = other.getBaseUri();
        if (this$baseUri == null ? other$baseUri != null : !this$baseUri.equals(other$baseUri)) {
            return false;
        }
        Retry this$retries = this.getRetries();
        Retry other$retries = other.getRetries();
        if (this$retries == null ? other$retries != null : !((Object)this$retries).equals(other$retries)) {
            return false;
        }
        AnalyticsProcessor this$analyticsProcessor = this.getAnalyticsProcessor();
        AnalyticsProcessor other$analyticsProcessor = other.getAnalyticsProcessor();
        if (this$analyticsProcessor == null ? other$analyticsProcessor != null : !((Object)this$analyticsProcessor).equals(other$analyticsProcessor)) {
            return false;
        }
        FlagsmithFlagDefaults this$flagsmithFlagDefaults = this.getFlagsmithFlagDefaults();
        FlagsmithFlagDefaults other$flagsmithFlagDefaults = other.getFlagsmithFlagDefaults();
        return !(this$flagsmithFlagDefaults == null ? other$flagsmithFlagDefaults != null : !this$flagsmithFlagDefaults.equals(other$flagsmithFlagDefaults));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enableLocalEvaluation = this.getEnableLocalEvaluation();
        result = result * 59 + ($enableLocalEvaluation == null ? 43 : ((Object)$enableLocalEvaluation).hashCode());
        Integer $environmentRefreshIntervalSeconds = this.getEnvironmentRefreshIntervalSeconds();
        result = result * 59 + ($environmentRefreshIntervalSeconds == null ? 43 : ((Object)$environmentRefreshIntervalSeconds).hashCode());
        Boolean $raiseUpdateEnvironmentErrorsOnStartup = this.getRaiseUpdateEnvironmentErrorsOnStartup();
        result = result * 59 + ($raiseUpdateEnvironmentErrorsOnStartup == null ? 43 : ((Object)$raiseUpdateEnvironmentErrorsOnStartup).hashCode());
        HttpUrl $flagsUri = this.getFlagsUri();
        result = result * 59 + ($flagsUri == null ? 43 : $flagsUri.hashCode());
        HttpUrl $identitiesUri = this.getIdentitiesUri();
        result = result * 59 + ($identitiesUri == null ? 43 : $identitiesUri.hashCode());
        HttpUrl $traitsUri = this.getTraitsUri();
        result = result * 59 + ($traitsUri == null ? 43 : $traitsUri.hashCode());
        HttpUrl $environmentUri = this.getEnvironmentUri();
        result = result * 59 + ($environmentUri == null ? 43 : $environmentUri.hashCode());
        OkHttpClient $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        HttpUrl $baseUri = this.getBaseUri();
        result = result * 59 + ($baseUri == null ? 43 : $baseUri.hashCode());
        Retry $retries = this.getRetries();
        result = result * 59 + ($retries == null ? 43 : ((Object)$retries).hashCode());
        AnalyticsProcessor $analyticsProcessor = this.getAnalyticsProcessor();
        result = result * 59 + ($analyticsProcessor == null ? 43 : ((Object)$analyticsProcessor).hashCode());
        FlagsmithFlagDefaults $flagsmithFlagDefaults = this.getFlagsmithFlagDefaults();
        result = result * 59 + ($flagsmithFlagDefaults == null ? 43 : $flagsmithFlagDefaults.hashCode());
        return result;
    }

    public String toString() {
        return "FlagsmithConfig(flagsUri=" + this.getFlagsUri() + ", identitiesUri=" + this.getIdentitiesUri() + ", traitsUri=" + this.getTraitsUri() + ", environmentUri=" + this.getEnvironmentUri() + ", httpClient=" + this.getHttpClient() + ", baseUri=" + this.getBaseUri() + ", retries=" + this.getRetries() + ", enableLocalEvaluation=" + this.getEnableLocalEvaluation() + ", environmentRefreshIntervalSeconds=" + this.getEnvironmentRefreshIntervalSeconds() + ", analyticsProcessor=" + this.getAnalyticsProcessor() + ", flagsmithFlagDefaults=" + this.getFlagsmithFlagDefaults() + ", raiseUpdateEnvironmentErrorsOnStartup=" + this.getRaiseUpdateEnvironmentErrorsOnStartup() + ")";
    }

    static /* synthetic */ HttpUrl access$1400() {
        return DEFAULT_BASE_URI;
    }

    public static class Builder {
        private final List<Interceptor> interceptors = new ArrayList<Interceptor>();
        private Proxy proxy;
        private HttpUrl baseUri = FlagsmithConfig.access$1400();
        private int connectTimeoutMillis = 2000;
        private int writeTimeoutMillis = 5000;
        private int readTimeoutMillis = 5000;
        private Retry retries = new Retry(3);
        private SSLSocketFactory sslSocketFactory;
        private X509TrustManager trustManager;
        private FlagsmithFlagDefaults flagsmithFlagDefaults;
        private AnalyticsProcessor analyticsProcessor;
        private Boolean enableLocalEvaluation = Boolean.FALSE;
        private Integer environmentRefreshIntervalSeconds = 60;
        private Boolean enableAnalytics = Boolean.FALSE;

        private Builder() {
        }

        public Builder baseUri(String baseUri) {
            if (baseUri != null) {
                this.baseUri = HttpUrl.parse((String)baseUri);
            }
            return this;
        }

        public Builder connectTimeout(int connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public Builder writeTimeout(int writeTimeoutMillis) {
            this.writeTimeoutMillis = writeTimeoutMillis;
            return this;
        }

        public Builder readTimeout(int readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
            this.sslSocketFactory = sslSocketFactory;
            this.trustManager = trustManager;
            return this;
        }

        public Builder addHttpInterceptor(Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder withProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder retries(Retry retries) {
            this.retries = retries;
            return this;
        }

        public Builder withLocalEvaluation(Boolean localEvaluation) {
            this.enableLocalEvaluation = localEvaluation;
            return this;
        }

        public Builder withEnvironmentRefreshIntervalSeconds(Integer seconds) {
            this.environmentRefreshIntervalSeconds = seconds;
            return this;
        }

        public Builder withAnalyticsProcessor(AnalyticsProcessor processor) {
            this.analyticsProcessor = processor;
            this.enableAnalytics = Boolean.TRUE;
            return this;
        }

        public Builder withEnableAnalytics(Boolean enable) {
            this.enableAnalytics = enable;
            return this;
        }

        public FlagsmithConfig build() {
            return new FlagsmithConfig(this);
        }
    }
}

