/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.threads;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flagsmith.FlagsmithLogger;
import com.flagsmith.MapperFactory;
import com.flagsmith.config.Retry;
import com.flagsmith.exceptions.FlagsmithApiError;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class RequestProcessor {
    private ExecutorService executor = Executors.newFixedThreadPool(3);
    private OkHttpClient client;
    private FlagsmithLogger logger;
    private Retry retries = new Retry(3);

    public RequestProcessor(OkHttpClient client, FlagsmithLogger logger) {
        this(client, logger, new Retry(3));
    }

    public RequestProcessor(OkHttpClient client, FlagsmithLogger logger, Retry retries) {
        this.client = client;
        this.logger = logger;
        this.retries = retries;
    }

    public <T> Future<T> executeAsync(Request request, TypeReference<T> clazz, Boolean doThrow) {
        return this.executeAsync(request, clazz, doThrow, this.retries);
    }

    public Future<JsonNode> executeAsync(Request request, Boolean doThrow) {
        return this.executeAsync(request, new TypeReference<JsonNode>(){}, doThrow, this.retries);
    }

    public <T> Future<T> executeAsync(Request request, TypeReference<T> clazz, Boolean doThrow, Retry retries) {
        CompletableFuture completableFuture = new CompletableFuture();
        Call call = this.getClient().newCall(request);
        Retry localRetry = retries.toBuilder().build();
        this.executor.submit(() -> {
            try {
                Integer statusCode = null;
                do {
                    localRetry.waitWithBackoff();
                    Boolean throwOrNot = localRetry.getAttempts() == localRetry.getTotal() ? doThrow : Boolean.FALSE;
                    try (Response response = call.execute();){
                        statusCode = response.code();
                        if (response.isSuccessful()) {
                            ObjectMapper mapper = MapperFactory.getMapper();
                            completableFuture.complete(mapper.readValue(response.body().string(), clazz));
                            break;
                        }
                        this.getLogger().httpError(request, response, (boolean)throwOrNot);
                    }
                    catch (IOException e) {
                        this.getLogger().httpError(request, e, (boolean)throwOrNot);
                    }
                    localRetry.retryAttempted();
                } while (localRetry.isRetry(statusCode).booleanValue());
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
            finally {
                if (!completableFuture.isDone()) {
                    if (doThrow.booleanValue()) {
                        completableFuture.obtrudeException(new FlagsmithApiError());
                    } else {
                        completableFuture.complete(null);
                    }
                }
            }
        });
        return completableFuture;
    }

    public void close() {
        this.executor.shutdown();
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public FlagsmithLogger getLogger() {
        return this.logger;
    }

    public Retry getRetries() {
        return this.retries;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setClient(OkHttpClient client) {
        this.client = client;
    }

    public void setLogger(FlagsmithLogger logger) {
        this.logger = logger;
    }

    public void setRetries(Retry retries) {
        this.retries = retries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestProcessor)) {
            return false;
        }
        RequestProcessor other = (RequestProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        OkHttpClient this$client = this.getClient();
        OkHttpClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        FlagsmithLogger this$logger = this.getLogger();
        FlagsmithLogger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        Retry this$retries = this.getRetries();
        Retry other$retries = other.getRetries();
        return !(this$retries == null ? other$retries != null : !((Object)this$retries).equals(other$retries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        OkHttpClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        FlagsmithLogger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        Retry $retries = this.getRetries();
        result = result * 59 + ($retries == null ? 43 : ((Object)$retries).hashCode());
        return result;
    }

    public String toString() {
        return "RequestProcessor(executor=" + this.getExecutor() + ", client=" + this.getClient() + ", logger=" + this.getLogger() + ", retries=" + this.getRetries() + ")";
    }
}

