/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.flagsmith.FlagsmithException;
import com.flagsmith.FlagsmithLoggerLevel;
import java.io.IOException;
import java.text.MessageFormat;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;

public class FlagsmithLogger {
    private Logger logger;
    private FlagsmithLoggerLevel level = FlagsmithLoggerLevel.ERROR;

    public void setLogger(Logger logger, FlagsmithLoggerLevel level) {
        this.logger = logger;
        this.level = level;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void httpError(Request request, Response response, boolean doThrow) {
        if (!this.isLoggingEnabled(FlagsmithLoggerLevel.ERROR) && !doThrow) {
            return;
        }
        String body = null;
        try {
            body = response.body().string();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String errorMessage = MessageFormat.format("Flagsmith: error when getting flags. Request: {0}, Response: {1} body[{2}]", request.url(), response, body);
        if (doThrow) {
            throw new FlagsmithException(errorMessage);
        }
        this.logger.error(errorMessage);
    }

    public void httpError(Request request, IOException io, boolean doReThrow) {
        if (doReThrow) {
            throw new FlagsmithException(io);
        }
        if (this.isLoggingEnabled(FlagsmithLoggerLevel.ERROR)) {
            this.logger.error("Flagsmith: error when getting flags. Request: {}", (Object)request.url(), (Object)io);
        }
    }

    public void error(String var1, Object ... var2) {
        if (this.isLoggingEnabled(FlagsmithLoggerLevel.ERROR)) {
            this.logger.error("Flagsmith: " + var1, var2);
        }
    }

    public void info(String var1, Object ... var2) {
        if (this.isLoggingEnabled(FlagsmithLoggerLevel.INFO)) {
            this.logger.info("Flagsmith: " + var1, var2);
        }
    }

    private boolean isLoggingEnabled(FlagsmithLoggerLevel loggerLevel) {
        return this.logger != null && loggerLevel.getValue() >= this.level.getValue();
    }
}

