/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.flagsmith.FlagsmithApiWrapper;
import com.flagsmith.FlagsmithFlagDefaults;
import com.flagsmith.FlagsmithLogger;
import com.flagsmith.FlagsmithLoggerLevel;
import com.flagsmith.config.FlagsmithCacheConfig;
import com.flagsmith.config.FlagsmithConfig;
import com.flagsmith.exceptions.FlagsmithApiError;
import com.flagsmith.exceptions.FlagsmithClientError;
import com.flagsmith.exceptions.FlagsmithRuntimeError;
import com.flagsmith.flagengine.Engine;
import com.flagsmith.flagengine.environments.EnvironmentModel;
import com.flagsmith.flagengine.features.FeatureStateModel;
import com.flagsmith.flagengine.identities.IdentityModel;
import com.flagsmith.flagengine.identities.traits.TraitModel;
import com.flagsmith.flagengine.segments.SegmentEvaluator;
import com.flagsmith.flagengine.segments.SegmentModel;
import com.flagsmith.interfaces.FlagsmithCache;
import com.flagsmith.interfaces.FlagsmithSdk;
import com.flagsmith.models.BaseFlag;
import com.flagsmith.models.Flags;
import com.flagsmith.models.Segment;
import com.flagsmith.threads.PollingManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagsmithClient {
    private final FlagsmithLogger logger = new FlagsmithLogger();
    private FlagsmithSdk flagsmithSdk;
    private EnvironmentModel environment;
    private PollingManager pollingManager;

    private FlagsmithClient() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void updateEnvironment() {
        try {
            EnvironmentModel updatedEnvironment = this.flagsmithSdk.getEnvironment();
            if (updatedEnvironment != null) {
                this.environment = updatedEnvironment;
            } else {
                this.logger.error(this.getEnvironmentUpdateErrorMessage(), new Object[0]);
            }
        }
        catch (RuntimeException e) {
            this.logger.error(this.getEnvironmentUpdateErrorMessage(), new Object[0]);
        }
    }

    public Flags getEnvironmentFlags() throws FlagsmithClientError {
        if (this.getShouldUseEnvironmentDocument().booleanValue()) {
            return this.getEnvironmentFlagsFromDocument();
        }
        return this.getEnvironmentFlagsFromApi();
    }

    public Flags getIdentityFlags(String identifier) throws FlagsmithClientError {
        return this.getIdentityFlags(identifier, new HashMap<String, Object>());
    }

    public Flags getIdentityFlags(String identifier, Map<String, Object> traits) throws FlagsmithClientError {
        if (this.getShouldUseEnvironmentDocument().booleanValue()) {
            return this.getIdentityFlagsFromDocument(identifier, traits);
        }
        return this.getIdentityFlagsFromApi(identifier, traits);
    }

    public List<Segment> getIdentitySegments(String identifier) throws FlagsmithClientError {
        return this.getIdentitySegments(identifier, null);
    }

    public List<Segment> getIdentitySegments(String identifier, Map<String, Object> traits) throws FlagsmithClientError {
        if (this.environment == null) {
            throw new FlagsmithClientError("Local evaluation required to obtain identity segments.");
        }
        IdentityModel identityModel = this.buildIdentityModel(identifier, traits != null ? traits : new HashMap());
        List<SegmentModel> segmentModels = SegmentEvaluator.getIdentitySegments(this.environment, identityModel);
        return segmentModels.stream().map(segmentModel -> {
            Segment segment = new Segment();
            segment.setId(segmentModel.getId());
            segment.setName(segmentModel.getName());
            return segment;
        }).collect(Collectors.toList());
    }

    public void close() {
        if (this.pollingManager != null) {
            this.pollingManager.stopPolling();
        }
        this.flagsmithSdk.close();
    }

    private Flags getEnvironmentFlagsFromDocument() throws FlagsmithClientError {
        if (this.environment == null) {
            if (this.getConfig().getFlagsmithFlagDefaults() == null) {
                throw new FlagsmithClientError("Unable to get flags. No environment present.");
            }
            return this.getDefaultFlags();
        }
        return Flags.fromFeatureStateModels(Engine.getEnvironmentFeatureStates(this.environment), this.getConfig().getAnalyticsProcessor(), null, this.getConfig().getFlagsmithFlagDefaults());
    }

    private Flags getIdentityFlagsFromDocument(String identifier, Map<String, Object> traits) throws FlagsmithClientError {
        if (this.environment == null) {
            if (this.getConfig().getFlagsmithFlagDefaults() == null) {
                throw new FlagsmithClientError("Unable to get flags. No environment present.");
            }
            return this.getDefaultFlags();
        }
        IdentityModel identity = this.buildIdentityModel(identifier, traits);
        List<FeatureStateModel> featureStates = Engine.getIdentityFeatureStates(this.environment, identity);
        return Flags.fromFeatureStateModels(featureStates, this.getConfig().getAnalyticsProcessor(), identity.getCompositeKey(), this.getConfig().getFlagsmithFlagDefaults());
    }

    private Flags getEnvironmentFlagsFromApi() throws FlagsmithApiError {
        try {
            return this.flagsmithSdk.getFeatureFlags(Boolean.TRUE);
        }
        catch (Exception e) {
            if (this.getConfig().getFlagsmithFlagDefaults() != null) {
                return this.getDefaultFlags();
            }
            if (this.environment != null) {
                try {
                    return this.getEnvironmentFlagsFromDocument();
                }
                catch (FlagsmithClientError flagsmithClientError) {
                    // empty catch block
                }
            }
            throw new FlagsmithApiError("Failed to get feature flags.");
        }
    }

    private Flags getIdentityFlagsFromApi(String identifier, Map<String, Object> traits) throws FlagsmithApiError {
        try {
            List<TraitModel> traitsList = traits.entrySet().stream().map(row -> {
                TraitModel trait = new TraitModel();
                trait.setTraitValue(row.getValue());
                trait.setTraitKey((String)row.getKey());
                return trait;
            }).collect(Collectors.toList());
            return this.flagsmithSdk.identifyUserWithTraits(identifier, traitsList, Boolean.TRUE);
        }
        catch (Exception e) {
            if (this.getConfig().getFlagsmithFlagDefaults() != null) {
                return this.getDefaultFlags();
            }
            if (this.environment != null) {
                try {
                    return this.getIdentityFlagsFromDocument(identifier, traits);
                }
                catch (FlagsmithClientError flagsmithClientError) {
                    // empty catch block
                }
            }
            throw new FlagsmithApiError("Failed to get feature flags.");
        }
    }

    private IdentityModel buildIdentityModel(String identifier, Map<String, Object> traits) throws FlagsmithClientError {
        if (this.environment == null) {
            throw new FlagsmithClientError("Unable to build identity model when no local environment present.");
        }
        List<TraitModel> traitsList = traits.entrySet().stream().map(entry -> {
            TraitModel trait = new TraitModel();
            trait.setTraitKey((String)entry.getKey());
            trait.setTraitValue(entry.getValue());
            return trait;
        }).collect(Collectors.toList());
        IdentityModel identity = new IdentityModel();
        identity.setIdentityTraits(traitsList);
        identity.setEnvironmentApiKey(this.environment.getApiKey());
        identity.setIdentifier(identifier);
        return identity;
    }

    private Flags getDefaultFlags() {
        Flags flags = new Flags();
        flags.setDefaultFlagHandler(this.getConfig().getFlagsmithFlagDefaults());
        return flags;
    }

    private String getEnvironmentUpdateErrorMessage() {
        if (this.environment == null) {
            return "Unable to update environment from API. No environment configured - using defaultHandler if configured.";
        }
        return "Unable to update environment from API. Continuing to use previous copy.";
    }

    private FlagsmithConfig getConfig() {
        return this.flagsmithSdk.getConfig();
    }

    public FlagsmithCache getCache() {
        return this.flagsmithSdk.getCache();
    }

    private Boolean getShouldUseEnvironmentDocument() {
        FlagsmithConfig config = this.getConfig();
        return config.getEnableLocalEvaluation() | config.getOfflineMode();
    }

    public FlagsmithLogger getLogger() {
        return this.logger;
    }

    public FlagsmithSdk getFlagsmithSdk() {
        return this.flagsmithSdk;
    }

    public EnvironmentModel getEnvironment() {
        return this.environment;
    }

    public PollingManager getPollingManager() {
        return this.pollingManager;
    }

    public void setFlagsmithSdk(FlagsmithSdk flagsmithSdk) {
        this.flagsmithSdk = flagsmithSdk;
    }

    public void setEnvironment(EnvironmentModel environment) {
        this.environment = environment;
    }

    public void setPollingManager(PollingManager pollingManager) {
        this.pollingManager = pollingManager;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlagsmithClient)) {
            return false;
        }
        FlagsmithClient other = (FlagsmithClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FlagsmithLogger this$logger = this.getLogger();
        FlagsmithLogger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        FlagsmithSdk this$flagsmithSdk = this.getFlagsmithSdk();
        FlagsmithSdk other$flagsmithSdk = other.getFlagsmithSdk();
        if (this$flagsmithSdk == null ? other$flagsmithSdk != null : !this$flagsmithSdk.equals(other$flagsmithSdk)) {
            return false;
        }
        EnvironmentModel this$environment = this.getEnvironment();
        EnvironmentModel other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment)) {
            return false;
        }
        PollingManager this$pollingManager = this.getPollingManager();
        PollingManager other$pollingManager = other.getPollingManager();
        return !(this$pollingManager == null ? other$pollingManager != null : !this$pollingManager.equals(other$pollingManager));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlagsmithClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FlagsmithLogger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        FlagsmithSdk $flagsmithSdk = this.getFlagsmithSdk();
        result = result * 59 + ($flagsmithSdk == null ? 43 : $flagsmithSdk.hashCode());
        EnvironmentModel $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        PollingManager $pollingManager = this.getPollingManager();
        result = result * 59 + ($pollingManager == null ? 43 : $pollingManager.hashCode());
        return result;
    }

    public String toString() {
        return "FlagsmithClient(logger=" + this.getLogger() + ", flagsmithSdk=" + this.getFlagsmithSdk() + ", environment=" + this.getEnvironment() + ", pollingManager=" + this.getPollingManager() + ")";
    }

    public static class Builder {
        private final FlagsmithClient client;
        private FlagsmithConfig configuration = FlagsmithConfig.newBuilder().build();
        private HashMap<String, String> customHeaders;
        private String apiKey;
        private FlagsmithCacheConfig cacheConfig;
        private PollingManager pollingManager;
        private FlagsmithApiWrapper flagsmithApiWrapper;

        private Builder() {
            this.client = new FlagsmithClient();
        }

        public Builder setApiKey(String apiKey) {
            if (null == apiKey) {
                throw new IllegalArgumentException("Api key can not be null");
            }
            this.apiKey = apiKey;
            return this;
        }

        public Builder setDefaultFlagValueFunction(@NonNull Function<String, BaseFlag> defaultFlagValueFunction) {
            if (defaultFlagValueFunction == null) {
                throw new IllegalArgumentException("defaultFlagValueFunction is marked non-null but is null");
            }
            if (this.configuration.getFlagsmithFlagDefaults() == null) {
                this.configuration.setFlagsmithFlagDefaults(new FlagsmithFlagDefaults());
            }
            this.configuration.getFlagsmithFlagDefaults().setDefaultFlagValueFunc(defaultFlagValueFunction);
            return this;
        }

        public Builder enableLogging(FlagsmithLoggerLevel level) {
            this.client.logger.setLogger(LoggerFactory.getLogger(FlagsmithClient.class), level);
            return this;
        }

        public Builder enableLogging() {
            this.client.logger.setLogger(LoggerFactory.getLogger(FlagsmithClient.class));
            return this;
        }

        public Builder enableLogging(Logger logger) {
            this.client.logger.setLogger(logger);
            return this;
        }

        public Builder withConfiguration(FlagsmithConfig config) {
            if (config != null) {
                this.configuration = config;
            }
            return this;
        }

        public Builder withApiUrl(String apiUrl) {
            if (apiUrl != null) {
                this.configuration = FlagsmithConfig.newBuilder().baseUri(apiUrl).build();
            }
            return this;
        }

        public Builder withCustomHttpHeaders(HashMap<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public Builder withCache(FlagsmithCacheConfig cacheConfig) {
            this.cacheConfig = cacheConfig;
            return this;
        }

        public Builder withPollingManager(PollingManager manager) {
            this.pollingManager = manager;
            return this;
        }

        public Builder withFlagsmithApiWrapper(FlagsmithApiWrapper flagsmithApiWrapper) {
            this.flagsmithApiWrapper = flagsmithApiWrapper;
            return this;
        }

        public FlagsmithClient build() {
            if (this.configuration.getOfflineMode().booleanValue() && this.configuration.getOfflineHandler() == null) {
                throw new FlagsmithRuntimeError("Offline handler must be provided to use offline mode.");
            }
            if (this.flagsmithApiWrapper != null) {
                this.client.flagsmithSdk = this.flagsmithApiWrapper;
            } else if (this.cacheConfig != null) {
                this.client.flagsmithSdk = new FlagsmithApiWrapper(this.cacheConfig.getCache(), this.configuration, this.customHeaders, this.client.logger, this.apiKey);
            } else {
                this.client.flagsmithSdk = new FlagsmithApiWrapper(this.configuration, this.customHeaders, this.client.logger, this.apiKey);
            }
            if (this.configuration.getAnalyticsProcessor() != null) {
                this.configuration.getAnalyticsProcessor().setApi(this.client.flagsmithSdk);
                this.configuration.getAnalyticsProcessor().setLogger(this.client.logger);
            }
            if (this.configuration.getEnableLocalEvaluation().booleanValue()) {
                if (this.configuration.getOfflineHandler() != null) {
                    throw new FlagsmithRuntimeError("Local evaluation and offline handler cannot be used together.");
                }
                if (!this.apiKey.startsWith("ser.")) {
                    throw new FlagsmithRuntimeError("In order to use local evaluation, please generate a server key in the environment settings page.");
                }
                if (this.pollingManager != null) {
                    this.client.pollingManager = this.pollingManager;
                } else {
                    this.client.pollingManager = new PollingManager(this.client, this.configuration.getEnvironmentRefreshIntervalSeconds());
                }
                this.client.pollingManager.startPolling();
            }
            if (this.configuration.getOfflineHandler() != null) {
                if (this.configuration.getFlagsmithFlagDefaults() != null) {
                    throw new FlagsmithRuntimeError("Cannot use both default flag handler and offline handler.");
                }
                this.client.environment = this.configuration.getOfflineHandler().getEnvironment();
            }
            return this.client;
        }
    }
}

