/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.models;

import com.fasterxml.jackson.databind.JsonNode;
import com.flagsmith.flagengine.features.FeatureStateModel;
import com.flagsmith.models.BaseFlag;

public class Flag
extends BaseFlag {
    private Integer featureId = 0;
    private Boolean isDefault;

    public static Flag fromFeatureStateModel(FeatureStateModel featureState, Object identityId) {
        Flag flag = new Flag();
        flag.setFeatureId(featureState.getFeature().getId());
        flag.setValue(featureState.getValue(identityId));
        flag.setFeatureName(featureState.getFeature().getName());
        flag.setEnabled(featureState.getEnabled());
        return flag;
    }

    public static Flag fromApiFlag(JsonNode node) {
        Flag flag = new Flag();
        flag.setFeatureId(node.get("feature").get("id").intValue());
        flag.setValue(node.get("feature_state_value"));
        flag.setFeatureName(node.get("feature").get("name").asText());
        flag.setEnabled(node.get("enabled").booleanValue());
        return flag;
    }

    public Integer getFeatureId() {
        return this.featureId;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setFeatureId(Integer featureId) {
        this.featureId = featureId;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flag)) {
            return false;
        }
        Flag other = (Flag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$featureId = this.getFeatureId();
        Integer other$featureId = other.getFeatureId();
        if (this$featureId == null ? other$featureId != null : !((Object)this$featureId).equals(other$featureId)) {
            return false;
        }
        Boolean this$isDefault = this.getIsDefault();
        Boolean other$isDefault = other.getIsDefault();
        return !(this$isDefault == null ? other$isDefault != null : !((Object)this$isDefault).equals(other$isDefault));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Flag;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $featureId = this.getFeatureId();
        result = result * 59 + ($featureId == null ? 43 : ((Object)$featureId).hashCode());
        Boolean $isDefault = this.getIsDefault();
        result = result * 59 + ($isDefault == null ? 43 : ((Object)$isDefault).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Flag(super=" + super.toString() + ", featureId=" + this.getFeatureId() + ", isDefault=" + this.getIsDefault() + ")";
    }
}

