/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.config;

import com.flagsmith.FlagsmithFlagDefaults;
import com.flagsmith.config.Retry;
import com.flagsmith.interfaces.IOfflineHandler;
import com.flagsmith.threads.AnalyticsProcessor;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public final class FlagsmithConfig {
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 2000;
    private static final int DEFAULT_WRITE_TIMEOUT_MILLIS = 5000;
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = 5000;
    private static final int DEFAULT_ENVIRONMENT_REFRESH_SECONDS = 60;
    private static final HttpUrl DEFAULT_BASE_URI = HttpUrl.parse((String)"https://edge.api.flagsmith.com/api/v1/");
    private final HttpUrl flagsUri;
    private final HttpUrl identitiesUri;
    private final HttpUrl traitsUri;
    private final HttpUrl environmentUri;
    private final OkHttpClient httpClient;
    private final HttpUrl baseUri;
    private final Retry retries;
    private Boolean enableLocalEvaluation;
    private Integer environmentRefreshIntervalSeconds;
    private AnalyticsProcessor analyticsProcessor;
    private FlagsmithFlagDefaults flagsmithFlagDefaults = null;
    private Boolean raiseUpdateEnvironmentErrorsOnStartup = true;
    private Boolean offlineMode = false;
    private IOfflineHandler offlineHandler = null;

    protected FlagsmithConfig(Builder builder) {
        this.baseUri = builder.baseUri;
        this.flagsUri = this.baseUri.newBuilder("flags/").build();
        this.identitiesUri = this.baseUri.newBuilder("identities/").build();
        this.traitsUri = this.baseUri.newBuilder("traits/").build();
        this.environmentUri = this.baseUri.newBuilder("environment-document/").build();
        OkHttpClient.Builder httpBuilder = new OkHttpClient.Builder().connectTimeout((long)builder.connectTimeoutMillis, TimeUnit.MILLISECONDS).writeTimeout((long)builder.writeTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout((long)builder.readTimeoutMillis, TimeUnit.MILLISECONDS);
        if (builder.sslSocketFactory != null && builder.trustManager != null) {
            httpBuilder.sslSocketFactory(builder.sslSocketFactory, builder.trustManager);
        }
        for (Interceptor interceptor : builder.interceptors) {
            httpBuilder.addInterceptor(interceptor);
        }
        if (builder.proxy != null) {
            httpBuilder.proxy(builder.proxy);
        }
        if (!builder.supportedProtocols.isEmpty()) {
            httpBuilder.protocols(builder.supportedProtocols.stream().map(Protocol::internalProtocol).collect(Collectors.toList()));
        }
        this.httpClient = httpBuilder.build();
        this.retries = builder.retries;
        this.enableLocalEvaluation = builder.enableLocalEvaluation;
        this.environmentRefreshIntervalSeconds = builder.environmentRefreshIntervalSeconds;
        if (builder.enableAnalytics.booleanValue()) {
            this.analyticsProcessor = builder.analyticsProcessor != null ? builder.analyticsProcessor : new AnalyticsProcessor(this.httpClient);
        }
        this.offlineMode = builder.offlineMode;
        this.offlineHandler = builder.offlineHandler;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void setFlagsmithFlagDefaults(FlagsmithFlagDefaults flagsmithFlagDefaults) {
        this.flagsmithFlagDefaults = flagsmithFlagDefaults;
    }

    @Generated
    public HttpUrl getFlagsUri() {
        return this.flagsUri;
    }

    @Generated
    public HttpUrl getIdentitiesUri() {
        return this.identitiesUri;
    }

    @Generated
    public HttpUrl getTraitsUri() {
        return this.traitsUri;
    }

    @Generated
    public HttpUrl getEnvironmentUri() {
        return this.environmentUri;
    }

    @Generated
    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public HttpUrl getBaseUri() {
        return this.baseUri;
    }

    @Generated
    public Retry getRetries() {
        return this.retries;
    }

    @Generated
    public Boolean getEnableLocalEvaluation() {
        return this.enableLocalEvaluation;
    }

    @Generated
    public Integer getEnvironmentRefreshIntervalSeconds() {
        return this.environmentRefreshIntervalSeconds;
    }

    @Generated
    public AnalyticsProcessor getAnalyticsProcessor() {
        return this.analyticsProcessor;
    }

    @Generated
    public FlagsmithFlagDefaults getFlagsmithFlagDefaults() {
        return this.flagsmithFlagDefaults;
    }

    @Generated
    public Boolean getRaiseUpdateEnvironmentErrorsOnStartup() {
        return this.raiseUpdateEnvironmentErrorsOnStartup;
    }

    @Generated
    public Boolean getOfflineMode() {
        return this.offlineMode;
    }

    @Generated
    public IOfflineHandler getOfflineHandler() {
        return this.offlineHandler;
    }

    static /* synthetic */ HttpUrl access$1700() {
        return DEFAULT_BASE_URI;
    }

    public static class Builder {
        private final List<Interceptor> interceptors = new ArrayList<Interceptor>();
        private Proxy proxy;
        private HttpUrl baseUri = FlagsmithConfig.access$1700();
        private int connectTimeoutMillis = 2000;
        private int writeTimeoutMillis = 5000;
        private int readTimeoutMillis = 5000;
        private List<Protocol> supportedProtocols = new ArrayList<Protocol>();
        private Retry retries = new Retry(3);
        private SSLSocketFactory sslSocketFactory;
        private X509TrustManager trustManager;
        private FlagsmithFlagDefaults flagsmithFlagDefaults;
        private AnalyticsProcessor analyticsProcessor;
        private Boolean enableLocalEvaluation = Boolean.FALSE;
        private Integer environmentRefreshIntervalSeconds = 60;
        private Boolean enableAnalytics = Boolean.FALSE;
        private Boolean offlineMode = Boolean.FALSE;
        private IOfflineHandler offlineHandler;

        private Builder() {
        }

        public Builder baseUri(String baseUri) {
            if (baseUri != null) {
                this.baseUri = HttpUrl.parse((String)baseUri);
            }
            return this;
        }

        public Builder connectTimeout(int connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public Builder writeTimeout(int writeTimeoutMillis) {
            this.writeTimeoutMillis = writeTimeoutMillis;
            return this;
        }

        public Builder readTimeout(int readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
            this.sslSocketFactory = sslSocketFactory;
            this.trustManager = trustManager;
            return this;
        }

        public Builder addHttpInterceptor(Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder withProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder retries(Retry retries) {
            this.retries = retries;
            return this;
        }

        public Builder withLocalEvaluation(Boolean localEvaluation) {
            this.enableLocalEvaluation = localEvaluation;
            return this;
        }

        public Builder withEnvironmentRefreshIntervalSeconds(Integer seconds) {
            this.environmentRefreshIntervalSeconds = seconds;
            return this;
        }

        public Builder withAnalyticsProcessor(AnalyticsProcessor processor) {
            this.analyticsProcessor = processor;
            this.enableAnalytics = Boolean.TRUE;
            return this;
        }

        public Builder withEnableAnalytics(Boolean enable) {
            this.enableAnalytics = enable;
            return this;
        }

        public Builder withOfflineMode(Boolean offlineMode) {
            this.offlineMode = offlineMode;
            return this;
        }

        public Builder withOfflineHandler(IOfflineHandler offlineHandler) {
            this.offlineHandler = offlineHandler;
            return this;
        }

        public Builder withSupportedProtocols(List<Protocol> supportedProtocols) {
            this.supportedProtocols.clear();
            this.supportedProtocols.addAll(supportedProtocols);
            return this;
        }

        public FlagsmithConfig build() {
            return new FlagsmithConfig(this);
        }
    }

    public static enum Protocol {
        HTTP_1_1(okhttp3.Protocol.HTTP_1_1),
        HTTP_2(okhttp3.Protocol.HTTP_2);

        private final okhttp3.Protocol protocol;

        private Protocol(okhttp3.Protocol protocol) {
            this.protocol = protocol;
        }

        okhttp3.Protocol internalProtocol() {
            return this.protocol;
        }
    }
}

