/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flagsmith.FlagsmithLogger;
import com.flagsmith.MapperFactory;
import com.flagsmith.config.FlagsmithConfig;
import com.flagsmith.exceptions.FlagsmithRuntimeError;
import com.flagsmith.flagengine.environments.EnvironmentModel;
import com.flagsmith.flagengine.features.FeatureStateModel;
import com.flagsmith.flagengine.identities.traits.TraitModel;
import com.flagsmith.interfaces.FlagsmithCache;
import com.flagsmith.interfaces.FlagsmithSdk;
import com.flagsmith.models.Flags;
import com.flagsmith.responses.FlagsAndTraitsResponse;
import com.flagsmith.threads.AnalyticsProcessor;
import com.flagsmith.threads.RequestProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class FlagsmithApiWrapper
implements FlagsmithSdk {
    private static final String AUTH_HEADER = "X-Environment-Key";
    private static final String ACCEPT_HEADER = "Accept";
    private static final Integer TIMEOUT = 15000;
    private final FlagsmithLogger logger;
    private final FlagsmithConfig defaultConfig;
    private final HashMap<String, String> customHeaders;
    private final String apiKey;
    private RequestProcessor requestor;
    private FlagsmithCache cache = null;

    public FlagsmithApiWrapper(FlagsmithCache cache, FlagsmithConfig defaultConfig, HashMap<String, String> customHeaders, FlagsmithLogger logger, String apiKey) {
        this(defaultConfig, customHeaders, logger, apiKey);
        this.cache = cache;
    }

    public FlagsmithApiWrapper(FlagsmithConfig defaultConfig, HashMap<String, String> customHeaders, FlagsmithLogger logger, String apiKey) {
        this.defaultConfig = defaultConfig;
        this.customHeaders = customHeaders;
        this.logger = logger;
        this.apiKey = apiKey;
        this.requestor = new RequestProcessor(defaultConfig.getHttpClient(), logger, defaultConfig.getRetries());
    }

    public FlagsmithApiWrapper(FlagsmithConfig defaultConfig, HashMap<String, String> customHeaders, FlagsmithLogger logger, String apiKey, RequestProcessor requestProcessor) {
        this.defaultConfig = defaultConfig;
        this.customHeaders = customHeaders;
        this.logger = logger;
        this.apiKey = apiKey;
        this.requestor = requestProcessor;
    }

    @Override
    public Flags getFeatureFlags(boolean doThrow) {
        Flags featureFlags;
        block7: {
            featureFlags = new Flags();
            if (this.getCache() != null && this.getCache().getEnvFlagsCacheKey() != null && (featureFlags = this.getCache().getIfPresent(this.getCache().getEnvFlagsCacheKey())) != null) {
                return featureFlags;
            }
            HttpUrl urlBuilder = this.defaultConfig.getFlagsUri();
            Request request = this.newGetRequest(urlBuilder);
            Future<List<FeatureStateModel>> featureFlagsFuture = this.requestor.executeAsync(request, new TypeReference<List<FeatureStateModel>>(){}, doThrow);
            try {
                List<FeatureStateModel> featureFlagsResponse = featureFlagsFuture.get(TIMEOUT.intValue(), TimeUnit.MILLISECONDS);
                if (featureFlagsResponse == null) {
                    featureFlagsResponse = new ArrayList<FeatureStateModel>();
                }
                featureFlags = Flags.fromApiFlags(featureFlagsResponse, this.getConfig().getAnalyticsProcessor(), this.getConfig().getFlagsmithFlagDefaults());
                if (this.getCache() != null && this.getCache().getEnvFlagsCacheKey() != null) {
                    this.getCache().getCache().put((Object)this.getCache().getEnvFlagsCacheKey(), (Object)featureFlags);
                    this.logger.info("Got feature flags for flags = {} and cached.", featureFlags);
                }
            }
            catch (TimeoutException te) {
                this.logger.error("Timed out on fetching Feature flags.", te);
            }
            catch (InterruptedException ie) {
                this.logger.error("Interrupted on fetching Feature flags.", ie);
            }
            catch (ExecutionException ee) {
                this.logger.error("Execution failed on fetching Feature flags.", ee);
                if (!doThrow) break block7;
                throw new FlagsmithRuntimeError(ee);
            }
        }
        this.logger.info("Got feature flags for flags = {}", featureFlags);
        return featureFlags;
    }

    @Override
    public Flags identifyUserWithTraits(String identifier, List<? extends TraitModel> traits, boolean isTransient, boolean doThrow) {
        Flags flags;
        block9: {
            this.assertValidUser(identifier);
            flags = null;
            String cacheKey = null;
            if (this.getCache() != null) {
                cacheKey = this.getCache().getIdentityFlagsCacheKey(identifier, isTransient);
                flags = this.getCache().getIfPresent(cacheKey);
                if (flags != null) {
                    return flags;
                }
            }
            ObjectNode node = MapperFactory.getMapper().createObjectNode();
            node.put("identifier", identifier);
            if (isTransient) {
                node.put("transient", true);
            }
            if (traits != null) {
                node.putPOJO("traits", traits);
            }
            MediaType json = MediaType.parse((String)"application/json; charset=utf-8");
            RequestBody body = RequestBody.create((String)node.toString(), (MediaType)json);
            HttpUrl url = this.defaultConfig.getIdentitiesUri();
            Request request = this.newPostRequest(url, body);
            Future<FlagsAndTraitsResponse> featureFlagsFuture = this.requestor.executeAsync(request, new TypeReference<FlagsAndTraitsResponse>(){}, doThrow);
            try {
                FlagsAndTraitsResponse flagsAndTraitsResponse = featureFlagsFuture.get(TIMEOUT.intValue(), TimeUnit.MILLISECONDS);
                ArrayList<FeatureStateModel> flagsArray = flagsAndTraitsResponse != null && flagsAndTraitsResponse.getFlags() != null ? flagsAndTraitsResponse.getFlags() : new ArrayList<FeatureStateModel>();
                flags = Flags.fromApiFlags(flagsArray, this.getConfig().getAnalyticsProcessor(), this.getConfig().getFlagsmithFlagDefaults());
                if (cacheKey != null) {
                    this.getCache().getCache().put((Object)cacheKey, (Object)flags);
                    this.logger.info("Cached flags for identity {}.", identifier);
                }
            }
            catch (TimeoutException ie) {
                this.logger.error("Timed out on fetching Feature flags.", ie);
            }
            catch (InterruptedException ie) {
                this.logger.error("Interrupted on fetching Feature flags.", ie);
            }
            catch (ExecutionException ee) {
                this.logger.error("Execution failed on fetching Feature flags.", ee);
                if (!doThrow) break block9;
                throw new FlagsmithRuntimeError(ee);
            }
        }
        this.logger.info("Got flags based on identify for identifier = {}, flags = {}", identifier, flags);
        return flags;
    }

    @Override
    public EnvironmentModel getEnvironment() {
        Request request = this.newGetRequest(this.defaultConfig.getEnvironmentUri());
        Future<EnvironmentModel> environmentFuture = this.requestor.executeAsync(request, new TypeReference<EnvironmentModel>(){}, Boolean.TRUE);
        try {
            return environmentFuture.get(TIMEOUT.intValue(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ie) {
            this.logger.error("Timed out on fetching Feature flags.", ie);
        }
        catch (InterruptedException ie) {
            this.logger.error("Environment loading interrupted.", ie);
        }
        catch (ExecutionException ee) {
            this.logger.error("Execution failed on Environment loading.", ee);
            throw new FlagsmithRuntimeError(ee);
        }
        return null;
    }

    @Override
    public RequestProcessor getRequestor() {
        return this.requestor;
    }

    public void setRequestor(RequestProcessor requestor) {
        this.requestor = requestor;
    }

    @Override
    public FlagsmithConfig getConfig() {
        return this.defaultConfig;
    }

    @Override
    public FlagsmithCache getCache() {
        return this.cache;
    }

    public FlagsmithLogger getLogger() {
        return this.logger;
    }

    private Request.Builder newRequestBuilder() {
        Request.Builder builder = new Request.Builder().header(AUTH_HEADER, this.apiKey).addHeader(ACCEPT_HEADER, "application/json");
        if (this.customHeaders != null && !this.customHeaders.isEmpty()) {
            this.customHeaders.forEach((k, v) -> builder.addHeader(k, v));
        }
        return builder;
    }

    @Override
    public Request newGetRequest(HttpUrl url) {
        Request.Builder builder = this.newRequestBuilder();
        builder.url(url);
        return builder.build();
    }

    @Override
    public Request newPostRequest(HttpUrl url, RequestBody body) {
        Request.Builder builder = this.newRequestBuilder();
        builder.url(url).post(body);
        return builder.build();
    }

    @Override
    public void close() {
        this.requestor.close();
        AnalyticsProcessor analyticsProcessor = this.getConfig().getAnalyticsProcessor();
        if (analyticsProcessor != null) {
            analyticsProcessor.close();
        }
    }

    @Generated
    public FlagsmithConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Generated
    public HashMap<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }
}

