/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine.utils;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hashing {
    private static Hashing instance = null;
    private static Logger logger = LoggerFactory.getLogger(Hashing.class);

    private Hashing() {
    }

    public static Hashing getInstance() {
        if (instance == null) {
            Hashing.setInstance(new Hashing());
        }
        return instance;
    }

    public static void setInstance(Hashing instanceObj) {
        instance = instanceObj;
    }

    public Float getHashedPercentageForObjectIds(List<String> ids) {
        return this.getHashedPercentageForObjectIds(ids, 1);
    }

    public Float getHashedPercentageForObjectIds(List<String> ids, Integer iterations) {
        String hashTo = ids.stream().collect(Collectors.joining(","));
        String hashToWithIteration = IntStream.rangeClosed(1, iterations).mapToObj(i -> hashTo).collect(Collectors.joining(","));
        String hashedString = this.getMD5(hashToWithIteration);
        BigInteger hashedBigInteger = new BigInteger(hashedString, 16);
        Float hashedFloat = Float.valueOf(hashedBigInteger.mod(new BigInteger("9999")).floatValue());
        if ((hashedFloat = Float.valueOf(hashedFloat.floatValue() / 9998.0f * 100.0f)).floatValue() == 100.0f) {
            return this.getHashedPercentageForObjectIds(ids, iterations + 1);
        }
        return hashedFloat;
    }

    public String getMD5(String hash) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(hash.getBytes("UTF-8"));
            byte[] digest = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02X", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("MD5 Hashing Algorithm not found.");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Encoding not supported.");
        }
        return null;
    }
}

