/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.models;

import com.fasterxml.jackson.databind.JsonNode;
import com.flagsmith.FlagsmithFlagDefaults;
import com.flagsmith.exceptions.FeatureNotFoundError;
import com.flagsmith.exceptions.FlagsmithClientError;
import com.flagsmith.flagengine.features.FeatureStateModel;
import com.flagsmith.interfaces.DefaultFlagHandler;
import com.flagsmith.models.BaseFlag;
import com.flagsmith.models.Flag;
import com.flagsmith.threads.AnalyticsProcessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class Flags {
    private Map<String, BaseFlag> flags = new HashMap<String, BaseFlag>();
    private AnalyticsProcessor analyticsProcessor;
    private DefaultFlagHandler defaultFlagHandler;

    public static Flags fromFeatureStateModels(List<FeatureStateModel> featureStates, AnalyticsProcessor analyticsProcessor) {
        return Flags.fromFeatureStateModels(featureStates, analyticsProcessor, null, null);
    }

    public static Flags fromFeatureStateModels(List<FeatureStateModel> featureStates, AnalyticsProcessor analyticsProcessor, Object identityId) {
        return Flags.fromFeatureStateModels(featureStates, analyticsProcessor, identityId, null);
    }

    public static Flags fromFeatureStateModels(List<FeatureStateModel> featureStates, AnalyticsProcessor analyticsProcessor, Object identityId, DefaultFlagHandler defaultFlagHandler) {
        Map<String, BaseFlag> flagMap = featureStates.stream().collect(Collectors.toMap(fs -> fs.getFeature().getName(), fs -> Flag.fromFeatureStateModel(fs, identityId)));
        Flags flags = new Flags();
        flags.setFlags(flagMap);
        flags.setAnalyticsProcessor(analyticsProcessor);
        flags.setDefaultFlagHandler(defaultFlagHandler);
        return flags;
    }

    public static Flags fromApiFlags(JsonNode apiFlags, AnalyticsProcessor analyticsProcessor, FlagsmithFlagDefaults defaultFlagHandler) {
        HashMap<String, BaseFlag> flagMap = new HashMap<String, BaseFlag>();
        for (JsonNode node : apiFlags) {
            flagMap.put(node.get("feature").get("name").asText(), Flag.fromApiFlag(node));
        }
        Flags flags = new Flags();
        flags.setFlags(flagMap);
        flags.setAnalyticsProcessor(analyticsProcessor);
        flags.setDefaultFlagHandler(defaultFlagHandler);
        return flags;
    }

    public static Flags fromApiFlags(List<FeatureStateModel> apiFlags, AnalyticsProcessor analyticsProcessor, FlagsmithFlagDefaults defaultFlagHandler) {
        HashMap<String, BaseFlag> flagMap = new HashMap<String, BaseFlag>();
        for (FeatureStateModel flag : apiFlags) {
            flagMap.put(flag.getFeature().getName(), Flag.fromFeatureStateModel(flag, null));
        }
        Flags flags = new Flags();
        flags.setFlags(flagMap);
        flags.setAnalyticsProcessor(analyticsProcessor);
        flags.setDefaultFlagHandler(defaultFlagHandler);
        return flags;
    }

    public List<BaseFlag> getAllFlags() {
        return this.flags.values().stream().collect(Collectors.toList());
    }

    public boolean isFeatureEnabled(String featureName) throws FlagsmithClientError {
        return this.getFlag(featureName).getEnabled();
    }

    public Object getFeatureValue(String featureName) throws FlagsmithClientError {
        return this.getFlag(featureName).getValue();
    }

    public BaseFlag getFlag(String featureName) throws FlagsmithClientError {
        Flag flagObj;
        if (!this.flags.containsKey(featureName)) {
            if (this.defaultFlagHandler != null) {
                return this.defaultFlagHandler.evaluateDefaultFlag(featureName);
            }
            throw new FeatureNotFoundError("Feature does not exist: " + featureName);
        }
        BaseFlag flag = this.flags.get(featureName);
        if (this.analyticsProcessor != null && flag instanceof Flag && (flagObj = (Flag)flag).getFeatureId() != null) {
            this.analyticsProcessor.trackFeature(flagObj.getFeatureName());
        }
        return flag;
    }

    @Generated
    public Flags() {
    }

    @Generated
    public Map<String, BaseFlag> getFlags() {
        return this.flags;
    }

    @Generated
    public AnalyticsProcessor getAnalyticsProcessor() {
        return this.analyticsProcessor;
    }

    @Generated
    public DefaultFlagHandler getDefaultFlagHandler() {
        return this.defaultFlagHandler;
    }

    @Generated
    public void setFlags(Map<String, BaseFlag> flags) {
        this.flags = flags;
    }

    @Generated
    public void setAnalyticsProcessor(AnalyticsProcessor analyticsProcessor) {
        this.analyticsProcessor = analyticsProcessor;
    }

    @Generated
    public void setDefaultFlagHandler(DefaultFlagHandler defaultFlagHandler) {
        this.defaultFlagHandler = defaultFlagHandler;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flags)) {
            return false;
        }
        Flags other = (Flags)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, BaseFlag> this$flags = this.getFlags();
        Map<String, BaseFlag> other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        AnalyticsProcessor this$analyticsProcessor = this.getAnalyticsProcessor();
        AnalyticsProcessor other$analyticsProcessor = other.getAnalyticsProcessor();
        if (this$analyticsProcessor == null ? other$analyticsProcessor != null : !this$analyticsProcessor.equals(other$analyticsProcessor)) {
            return false;
        }
        DefaultFlagHandler this$defaultFlagHandler = this.getDefaultFlagHandler();
        DefaultFlagHandler other$defaultFlagHandler = other.getDefaultFlagHandler();
        return !(this$defaultFlagHandler == null ? other$defaultFlagHandler != null : !this$defaultFlagHandler.equals(other$defaultFlagHandler));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Flags;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, BaseFlag> $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        AnalyticsProcessor $analyticsProcessor = this.getAnalyticsProcessor();
        result = result * 59 + ($analyticsProcessor == null ? 43 : $analyticsProcessor.hashCode());
        DefaultFlagHandler $defaultFlagHandler = this.getDefaultFlagHandler();
        result = result * 59 + ($defaultFlagHandler == null ? 43 : $defaultFlagHandler.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Flags(flags=" + this.getFlags() + ", analyticsProcessor=" + this.getAnalyticsProcessor() + ", defaultFlagHandler=" + this.getDefaultFlagHandler() + ")";
    }
}

