/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.flagsmith.flagengine.FeatureValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"key", "name", "enabled", "value", "variants", "priority", "metadata"})
public class FeatureContext {
    @JsonProperty(value="key")
    @JsonPropertyDescription(value="Unique feature key used when selecting a variant if the feature is multivariate. Set to an internal identifier or a UUID, depending on Flagsmith implementation.")
    private String key;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Feature name.")
    private String name;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Indicates whether the feature is enabled in the environment.")
    private Boolean enabled;
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="A default environment value for the feature. If the feature is multivariate, this will be the control value.")
    private Object value;
    @JsonProperty(value="variants")
    @JsonPropertyDescription(value="An array of environment default values associated with the feature. Empty for standard features, or contains multiple values for multivariate features.")
    private List<FeatureValue> variants = new ArrayList<FeatureValue>();
    @JsonProperty(value="priority")
    @JsonPropertyDescription(value="Priority of the feature context. Lower values indicate a higher priority when multiple contexts apply to the same feature.")
    private Double priority;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Additional metadata associated with the feature.")
    private Map<String, Object> metadata;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public FeatureContext() {
    }

    public FeatureContext(FeatureContext source) {
        this.key = source.key;
        this.name = source.name;
        this.enabled = source.enabled;
        this.value = source.value;
        this.variants = source.variants;
        this.priority = source.priority;
        this.metadata = source.metadata;
    }

    public FeatureContext(String key, String name, Boolean enabled, Object value, List<FeatureValue> variants, Double priority, Map<String, Object> metadata) {
        this.key = key;
        this.name = name;
        this.enabled = enabled;
        this.value = value;
        this.variants = variants;
        this.priority = priority;
        this.metadata = metadata;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public FeatureContext withKey(String key) {
        this.key = key;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public FeatureContext withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public FeatureContext withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty(value="value")
    public Object getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(Object value) {
        this.value = value;
    }

    public FeatureContext withValue(Object value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="variants")
    public List<FeatureValue> getVariants() {
        return this.variants;
    }

    @JsonProperty(value="variants")
    public void setVariants(List<FeatureValue> variants) {
        this.variants = variants;
    }

    public FeatureContext withVariants(List<FeatureValue> variants) {
        this.variants = variants;
        return this;
    }

    @JsonProperty(value="priority")
    public Double getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    public void setPriority(Double priority) {
        this.priority = priority;
    }

    public FeatureContext withPriority(Double priority) {
        this.priority = priority;
        return this;
    }

    @JsonProperty(value="metadata")
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public FeatureContext withMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public FeatureContext withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FeatureContext.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("key");
        sb.append('=');
        sb.append(this.key == null ? "<null>" : this.key);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("enabled");
        sb.append('=');
        sb.append(this.enabled == null ? "<null>" : this.enabled);
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        sb.append("variants");
        sb.append('=');
        sb.append(this.variants == null ? "<null>" : this.variants);
        sb.append(',');
        sb.append("priority");
        sb.append('=');
        sb.append(this.priority == null ? "<null>" : this.priority);
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(this.metadata == null ? "<null>" : this.metadata);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.variants == null ? 0 : this.variants.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.priority == null ? 0 : this.priority.hashCode());
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        result = result * 31 + (this.key == null ? 0 : this.key.hashCode());
        result = result * 31 + (this.enabled == null ? 0 : this.enabled.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FeatureContext)) {
            return false;
        }
        FeatureContext rhs = (FeatureContext)other;
        return (this.metadata == rhs.metadata || this.metadata != null && this.metadata.equals(rhs.metadata)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.variants == rhs.variants || this.variants != null && this.variants.equals(rhs.variants)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.priority == rhs.priority || this.priority != null && this.priority.equals(rhs.priority)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value)) && (this.key == rhs.key || this.key != null && this.key.equals(rhs.key)) && (this.enabled == rhs.enabled || this.enabled != null && this.enabled.equals(rhs.enabled));
    }
}

