/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "enabled", "value", "reason", "metadata"})
public class FlagResult {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Feature name.")
    private String name;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Indicates if the feature flag is enabled.")
    private Boolean enabled;
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="Feature flag value.")
    private Object value;
    @JsonProperty(value="reason")
    @JsonPropertyDescription(value="Reason for the feature flag evaluation.")
    private String reason;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Additional metadata associated with the feature.")
    private Map<String, Object> metadata;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public FlagResult() {
    }

    public FlagResult(FlagResult source) {
        this.name = source.name;
        this.enabled = source.enabled;
        this.value = source.value;
        this.reason = source.reason;
        this.metadata = source.metadata;
    }

    public FlagResult(String name, Boolean enabled, Object value, String reason, Map<String, Object> metadata) {
        this.name = name;
        this.enabled = enabled;
        this.value = value;
        this.reason = reason;
        this.metadata = metadata;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public FlagResult withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public FlagResult withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty(value="value")
    public Object getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(Object value) {
        this.value = value;
    }

    public FlagResult withValue(Object value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    public FlagResult withReason(String reason) {
        this.reason = reason;
        return this;
    }

    @JsonProperty(value="metadata")
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public FlagResult withMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public FlagResult withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FlagResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("enabled");
        sb.append('=');
        sb.append(this.enabled == null ? "<null>" : this.enabled);
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        sb.append("reason");
        sb.append('=');
        sb.append(this.reason == null ? "<null>" : this.reason);
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(this.metadata == null ? "<null>" : this.metadata);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.reason == null ? 0 : this.reason.hashCode());
        result = result * 31 + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        result = result * 31 + (this.enabled == null ? 0 : this.enabled.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FlagResult)) {
            return false;
        }
        FlagResult rhs = (FlagResult)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.reason == rhs.reason || this.reason != null && this.reason.equals(rhs.reason)) && (this.metadata == rhs.metadata || this.metadata != null && this.metadata.equals(rhs.metadata)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value)) && (this.enabled == rhs.enabled || this.enabled != null && this.enabled.equals(rhs.enabled));
    }
}

